/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.googleapis.extensions.appengine.auth.oauth2;

import com.google.appengine.api.appidentity.AppIdentityService;
import com.google.appengine.api.appidentity.AppIdentityServiceFactory;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.BearerToken;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.appengine.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.util.Beta;
import com.google.appengine.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AppIdentityCredential
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final AppIdentityService appIdentityService;
    private final Collection<String> scopes;

    public AppIdentityCredential(Collection<String> scopes) {
        this(new Builder(scopes));
    }

    protected AppIdentityCredential(Builder builder) {
        this.appIdentityService = builder.appIdentityService == null ? AppIdentityServiceFactory.getAppIdentityService() : builder.appIdentityService;
        this.scopes = builder.scopes;
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        String accessToken = this.appIdentityService.getAccessToken(this.scopes).getAccessToken();
        BearerToken.authorizationHeaderAccessMethod().intercept(request, accessToken);
    }

    public final AppIdentityService getAppIdentityService() {
        return this.appIdentityService;
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    @Beta
    public static class AppEngineCredentialWrapper
    extends GoogleCredential {
        private final AppIdentityCredential appIdentity;
        private final boolean scopesRequired;

        public AppEngineCredentialWrapper(HttpTransport transport, JsonFactory jsonFactory) throws IOException {
            this(AppEngineCredentialWrapper.getCheckedAppIdentityCredential(), Preconditions.checkNotNull(transport), Preconditions.checkNotNull(jsonFactory));
        }

        AppEngineCredentialWrapper(AppIdentityCredential appIdentity, HttpTransport transport, JsonFactory jsonFactory) {
            super(new GoogleCredential.Builder().setRequestInitializer(appIdentity).setTransport(transport).setJsonFactory(jsonFactory));
            this.appIdentity = appIdentity;
            Collection<String> scopes = appIdentity.getScopes();
            this.scopesRequired = scopes == null || scopes.isEmpty();
        }

        private static AppIdentityCredential getCheckedAppIdentityCredential() throws IOException {
            List<String> emptyScopes = Collections.emptyList();
            AppIdentityCredential appIdentity = new AppIdentityCredential(emptyScopes);
            if (appIdentity.getAppIdentityService() == null) {
                throw new IOException("AppIdentityService not available.");
            }
            return appIdentity;
        }

        @Override
        public void intercept(HttpRequest request) throws IOException {
            this.appIdentity.intercept(request);
        }

        @Override
        public boolean createScopedRequired() {
            return this.scopesRequired;
        }

        @Override
        public GoogleCredential createScoped(Collection<String> scopes) {
            return new AppEngineCredentialWrapper(new Builder(scopes).setAppIdentityService(this.appIdentity.getAppIdentityService()).build(), this.getTransport(), this.getJsonFactory());
        }

        @Override
        protected TokenResponse executeRefreshToken() throws IOException {
            AppIdentityService.GetAccessTokenResult tokenResult = this.appIdentity.getAppIdentityService().getAccessToken(this.appIdentity.getScopes());
            TokenResponse response = new TokenResponse();
            response.setAccessToken(tokenResult.getAccessToken());
            long expiresInSeconds = (tokenResult.getExpirationTime().getTime() - System.currentTimeMillis()) / 1000L;
            response.setExpiresInSeconds(expiresInSeconds);
            return response;
        }
    }

    public static class Builder {
        AppIdentityService appIdentityService;
        final Collection<String> scopes;

        public Builder(Collection<String> scopes) {
            this.scopes = Collections.unmodifiableCollection(scopes);
        }

        public final AppIdentityService getAppIdentityService() {
            return this.appIdentityService;
        }

        public Builder setAppIdentityService(AppIdentityService appIdentityService) {
            this.appIdentityService = appIdentityService;
            return this;
        }

        public AppIdentityCredential build() {
            return new AppIdentityCredential(this);
        }

        public final Collection<String> getScopes() {
            return this.scopes;
        }
    }
}

