/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.appidentity;

import com.google.appengine.api.appidentity.PublicCertificate;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

public interface AppIdentityService {
    public SigningResult signForApp(byte[] var1);

    public Collection<PublicCertificate> getPublicCertificatesForApp();

    public String getServiceAccountName();

    public String getDefaultGcsBucketName();

    public GetAccessTokenResult getAccessTokenUncached(Iterable<String> var1);

    public GetAccessTokenResult getAccessToken(Iterable<String> var1);

    public ParsedAppId parseFullAppId(String var1);

    public static final class ParsedAppId {
        private final String partition;
        private final String domain;
        private final String id;

        ParsedAppId(String partition, String domain, String id) {
            this.partition = partition;
            this.domain = domain;
            this.id = id;
        }

        public String getPartition() {
            return this.partition;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class GetAccessTokenResult
    implements Serializable {
        private static final long serialVersionUID = 1311635361L;
        private final String accessToken;
        private final Date expirationTime;

        public GetAccessTokenResult(String accessToken, Date expirationTime) {
            this.accessToken = accessToken;
            this.expirationTime = expirationTime;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public Date getExpirationTime() {
            return this.expirationTime;
        }
    }

    public static class SigningResult {
        private final String keyName;
        private byte[] signature;

        public SigningResult(String keyName, byte[] signature) {
            this.keyName = keyName;
            this.signature = signature;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public byte[] getSignature() {
            return this.signature;
        }
    }
}

