/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.Map;
import java.util.TreeMap;

@Deprecated
public class GSFileOptions {
    public static final String GS_USER_METADATA_PREFIX = "x-goog-meta-";
    final String fileName;
    final String mimeType;
    final String acl;
    final String cacheControl;
    final String contentEncoding;
    final String contentDisposition;
    final Map<String, String> userMetadata = new TreeMap<String, String>();

    private GSFileOptions(String bucket, String key, String mimeType, String acl, String cacheControl, String contentEncoding, String contentDisposition, Map<String, String> userMetadata) {
        Preconditions.checkArgument(bucket != null && !bucket.isEmpty(), "Must provide bucket");
        Preconditions.checkArgument(key != null && !key.isEmpty(), "Must provide key");
        this.fileName = new StringBuilder(5 + String.valueOf(bucket).length() + String.valueOf(key).length()).append("/gs/").append(bucket).append("/").append(key).toString();
        this.mimeType = mimeType == null || mimeType.trim().isEmpty() ? "application/octet-stream" : mimeType;
        this.acl = acl;
        this.cacheControl = cacheControl;
        this.contentEncoding = contentEncoding;
        this.contentDisposition = contentDisposition;
        if (userMetadata != null) {
            this.userMetadata.putAll(userMetadata);
        }
    }

    public static class GSFileOptionsBuilder {
        String bucket;
        String key;
        String mimeType;
        String acl;
        String cacheControl;
        String contentEncoding;
        String contentDisposition;
        Map<String, String> userMetadata = new TreeMap<String, String>();

        public GSFileOptionsBuilder setBucket(String bucket) {
            this.bucket = Preconditions.checkNotNull(bucket);
            return this;
        }

        public GSFileOptionsBuilder setKey(String key) {
            this.key = Preconditions.checkNotNull(key);
            return this;
        }

        public GSFileOptionsBuilder setMimeType(String mimeType) {
            this.mimeType = Preconditions.checkNotNull(mimeType);
            return this;
        }

        public GSFileOptionsBuilder setAcl(String acl) {
            this.acl = Preconditions.checkNotNull(acl);
            return this;
        }

        public GSFileOptionsBuilder setCacheControl(String cacheControl) {
            this.cacheControl = Preconditions.checkNotNull(cacheControl);
            return this;
        }

        public GSFileOptionsBuilder setContentEncoding(String contentEncoding) {
            this.contentEncoding = Preconditions.checkNotNull(contentEncoding);
            return this;
        }

        public GSFileOptionsBuilder setContentDisposition(String contentDisposition) {
            this.contentDisposition = Preconditions.checkNotNull(contentDisposition);
            return this;
        }

        public GSFileOptionsBuilder addUserMetadata(String key, String value) {
            Preconditions.checkArgument(key != null && !key.isEmpty());
            Preconditions.checkArgument(value != null && !value.isEmpty());
            this.userMetadata.put(key, value);
            return this;
        }

        public GSFileOptions build() {
            return new GSFileOptions(this.bucket, this.key, this.mimeType, this.acl, this.cacheControl, this.contentEncoding, this.contentDisposition, this.userMetadata);
        }
    }
}

