/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.CollectPreconditions;
import com.google.appengine.repackaged.com.google.common.collect.PrefixMap;
import com.google.appengine.repackaged.com.google.common.collect.PrefixTrie;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.Immutable;
import java.util.Map;
import javax.annotation.Nullable;

@Immutable(containerOf={"T"})
@GoogleInternal
@GwtIncompatible
public final class ImmutablePrefixTrie<T>
implements PrefixMap<T> {
    private final PrefixTrie<T> internalTrie;

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public T put(CharSequence prefix, T value) {
        throw new UnsupportedOperationException("method put(CharSequence, T) not supported by ImmutablePrefixTrie.");
    }

    @Override
    public T get(CharSequence s) {
        Preconditions.checkNotNull(s);
        return this.internalTrie == null ? null : (T)this.internalTrie.get(s);
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public T remove(CharSequence prefix) {
        throw new UnsupportedOperationException("method remove(CharSequence) not supported by ImmutablePrefixTrie.");
    }

    public static <T> Builder<T> builder() {
        return new Builder('\u0000', '\u007f');
    }

    public static <T> Builder<T> builderForRange(char first, char last) {
        return new Builder(first, last);
    }

    public static <T> Builder<T> numericBuilder() {
        return new Builder('0', '9');
    }

    public static <T> Builder<T> alphaBuilder() {
        return new Builder('A', 'z');
    }

    public static <T> ImmutablePrefixTrie<T> fromMap(Map<? extends CharSequence, ? extends T> source) {
        return ImmutablePrefixTrie.fromMapForRange(source, '\u0000', '\u007f');
    }

    public static <T> ImmutablePrefixTrie<T> fromMapForRange(Map<? extends CharSequence, ? extends T> source, char first, char last) {
        Preconditions.checkNotNull(source);
        if (source.isEmpty()) {
            return new ImmutablePrefixTrie<T>(null);
        }
        PrefixTrie<T> trie = new PrefixTrie<T>(first, last);
        for (Map.Entry<CharSequence, T> e : source.entrySet()) {
            CharSequence prefix = e.getKey();
            T v = e.getValue();
            CollectPreconditions.checkEntryNotNull(prefix, v);
            ImmutablePrefixTrie.checkPrefixInRange(prefix, first, last);
            trie.put(prefix, v);
        }
        return new ImmutablePrefixTrie(trie);
    }

    private ImmutablePrefixTrie(@Nullable PrefixTrie<T> internalTrie) {
        this.internalTrie = internalTrie;
    }

    private static void checkPrefixInRange(CharSequence prefix, char first, char last) {
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (c >= first && c <= last) continue;
            throw new IllegalArgumentException(String.format("\"%s\" contains characters outside of range: ['%c':'%c']", prefix, Character.valueOf(first), Character.valueOf(last)));
        }
    }

    public static final class Builder<T> {
        private final char first;
        private final char last;
        private PrefixTrie<T> internal;
        private boolean needsCopy;

        private Builder(char first, char last) {
            if (first > last) {
                throw new IllegalArgumentException(String.format("First char in range ('%c') is greater than last char in range ('%c')", Character.valueOf(first), Character.valueOf(last)));
            }
            this.first = first;
            this.last = last;
            this.needsCopy = false;
            this.internal = new PrefixTrie(first, last);
        }

        @CanIgnoreReturnValue
        public Builder<T> put(CharSequence prefix, T value) {
            T prev;
            CollectPreconditions.checkEntryNotNull(prefix, value);
            ImmutablePrefixTrie.checkPrefixInRange(prefix, this.first, this.last);
            if (this.needsCopy) {
                this.copyInternal();
                this.needsCopy = false;
            }
            if ((prev = this.internal.put(prefix, value)) != null) {
                this.internal.put(prefix, prev);
                throw new IllegalArgumentException(String.format("Builder already contains prefix: %s", prefix));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> putAll(Map<? extends CharSequence, ? extends T> prefixMap) {
            Preconditions.checkNotNull(prefixMap);
            for (Map.Entry<CharSequence, T> e : prefixMap.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder<T> putAll(ImmutablePrefixTrie<? extends T> immutablePrefixTrie) {
            Preconditions.checkNotNull(immutablePrefixTrie);
            this.putAll(((ImmutablePrefixTrie)immutablePrefixTrie).internalTrie.toMap());
            return this;
        }

        public ImmutablePrefixTrie<T> build() {
            this.needsCopy = true;
            return new ImmutablePrefixTrie(this.internal);
        }

        private void copyInternal() {
            Map<String, T> prefixMap = this.internal.toMap();
            this.internal = new PrefixTrie(this.first, this.last);
            for (Map.Entry<String, T> e : prefixMap.entrySet()) {
                this.internal.put(e.getKey(), e.getValue());
            }
        }
    }
}

