/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.chrono;

import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.chrono.BasicChronology;
import com.google.appengine.repackaged.org.joda.time.field.PreciseDurationDateTimeField;

final class BasicDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -4677223814028011723L;
    private final BasicChronology iChronology;

    BasicDayOfMonthDateTimeField(BasicChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfMonth(), days);
        this.iChronology = chronology;
    }

    @Override
    public int get(long instant) {
        return this.iChronology.getDayOfMonth(instant);
    }

    @Override
    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    @Override
    public int getMinimumValue() {
        return 1;
    }

    @Override
    public int getMaximumValue() {
        return this.iChronology.getDaysInMonthMax();
    }

    @Override
    public int getMaximumValue(long instant) {
        return this.iChronology.getDaysInMonthMax(instant);
    }

    @Override
    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.monthOfYear())) {
            int month = partial.get(DateTimeFieldType.monthOfYear());
            if (partial.isSupported(DateTimeFieldType.year())) {
                int year = partial.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(year, month);
            }
            return this.iChronology.getDaysInMonthMax(month);
        }
        return this.getMaximumValue();
    }

    @Override
    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        for (int i = 0; i < size; ++i) {
            if (partial.getFieldType(i) != DateTimeFieldType.monthOfYear()) continue;
            int month = values[i];
            for (int j = 0; j < size; ++j) {
                if (partial.getFieldType(j) != DateTimeFieldType.year()) continue;
                int year = values[j];
                return this.iChronology.getDaysInYearMonth(year, month);
            }
            return this.iChronology.getDaysInMonthMax(month);
        }
        return this.getMaximumValue();
    }

    @Override
    protected int getMaximumValueForSet(long instant, int value) {
        return this.iChronology.getDaysInMonthMaxForSet(instant, value);
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }
}

