/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.tz;

import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class FixedDateTimeZone
extends DateTimeZone {
    private static final long serialVersionUID = -3513011772763289092L;
    private final String iNameKey;
    private final int iWallOffset;
    private final int iStandardOffset;

    public FixedDateTimeZone(String id, String nameKey, int wallOffset, int standardOffset) {
        super(id);
        this.iNameKey = nameKey;
        this.iWallOffset = wallOffset;
        this.iStandardOffset = standardOffset;
    }

    @Override
    public String getNameKey(long instant) {
        return this.iNameKey;
    }

    @Override
    public int getOffset(long instant) {
        return this.iWallOffset;
    }

    @Override
    public int getStandardOffset(long instant) {
        return this.iStandardOffset;
    }

    @Override
    public int getOffsetFromLocal(long instantLocal) {
        return this.iWallOffset;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public long nextTransition(long instant) {
        return instant;
    }

    @Override
    public long previousTransition(long instant) {
        return instant;
    }

    @Override
    public TimeZone toTimeZone() {
        String id = this.getID();
        if (id.length() == 6 && (id.startsWith("+") || id.startsWith("-"))) {
            String string = String.valueOf(this.getID());
            return TimeZone.getTimeZone(string.length() != 0 ? "GMT".concat(string) : new String("GMT"));
        }
        return new SimpleTimeZone(this.iWallOffset, this.getID());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FixedDateTimeZone) {
            FixedDateTimeZone other = (FixedDateTimeZone)obj;
            return this.getID().equals(other.getID()) && this.iStandardOffset == other.iStandardOffset && this.iWallOffset == other.iWallOffset;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getID().hashCode() + 37 * this.iStandardOffset + 31 * this.iWallOffset;
    }
}

