/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.enhancer.asm.method;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.asm.ASMClassMethod;
import org.datanucleus.enhancer.asm.ASMUtils;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

/**
 * Method to generate the method "jdoGetPersistenceManager" using ASM.
 * <pre>
 * public final PersistenceManager jdoGetPersistenceManager()
 * {
 *     return (jdoStateManager != null ? jdoStateManager.getPersistenceManager(this) : null);
 * }
 * </pre>
 * @version $Revision: 1.5 $
 */
public class JdoGetPersistenceManager extends ASMClassMethod
{
    public static JdoGetPersistenceManager getInstance(ClassEnhancer enhancer)
    {
        return new JdoGetPersistenceManager(enhancer, ClassEnhancer.MN_JdoGetPersistenceManager, 
            Opcodes.ACC_PUBLIC | Opcodes.ACC_FINAL,
            javax.jdo.PersistenceManager.class, null, null);
    }

    /**
     * Constructor.
     * @param enhancer ClassEnhancer
     * @param name Name of method
     * @param access Access type
     * @param returnType Return type
     * @param argTypes Argument types
     * @param argNames Argument names
     */
    public JdoGetPersistenceManager(ClassEnhancer enhancer, String name, int access, 
        Object returnType, Object[] argTypes, String[] argNames)
    {
        super(enhancer, name, access, returnType, argTypes, argNames);
    }

    /**
     * Method to add the contents of the class method.
     */
    public void execute()
    {
        visitor.visitCode();

        Label l0 = new Label();
        visitor.visitLabel(l0);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitFieldInsn(Opcodes.GETFIELD, getClassEnhancer().getASMClassName(),
            ClassEnhancer.FN_StateManager, ASMUtils.CD_StateManager);
        Label l1 = new Label();
        visitor.visitJumpInsn(Opcodes.IFNULL, l1);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitFieldInsn(Opcodes.GETFIELD, getClassEnhancer().getASMClassName(),
            ClassEnhancer.FN_StateManager, ASMUtils.CD_StateManager);
        visitor.visitVarInsn(Opcodes.ALOAD, 0);
        visitor.visitMethodInsn(Opcodes.INVOKEINTERFACE, ASMUtils.ACN_StateManager,
            "getPersistenceManager", 
            "(" + ASMUtils.CD_PersistenceCapable + ")" + ASMUtils.CD_PersistenceManager);
        Label l2 = new Label();
        visitor.visitJumpInsn(Opcodes.GOTO, l2);
        visitor.visitLabel(l1);
        visitor.visitInsn(Opcodes.ACONST_NULL);
        visitor.visitLabel(l2);
        visitor.visitInsn(Opcodes.ARETURN);
        Label l3 = new Label();
        visitor.visitLabel(l3);
        visitor.visitLocalVariable("this", getClassEnhancer().getClassDescriptor(), null, l0, l3, 0);
        visitor.visitMaxs(2, 1);

        visitor.visitEnd();
    }
}