/**********************************************************************
Copyright (c) 2002 Mike Martin (TJDO) and others. All rights reserved. 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License. 
 

Contributors:
2003 Andy Jefferson - coding standards
    ...
**********************************************************************/
package org.datanucleus.store.mapped.expression;

import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.query.ResultObjectFactory;

/**
 * Indicates an object that can be queried, such as an Extent or persistent collection.
 *
 * @version $Revision: 1.8 $
 */
public interface Queryable
{
    /**
     * Returns a proto-typical query statement over the underlying collection.
     * <p>
     * The returned query statement selects all applicable rows from the
     * relevant base table(s) and the column that represents the element or element ID.
     * The statement can then be modified to join additional tables, select more columns, add WHERE conditions, etc.
     * @return The new prototypical query statement.
     */
    QueryExpression newQueryStatement();

    /**
     * Returns a prototypical query statement over the underlying collection,
     * pre-filtered to include only objects of the specified class.
     *
     * @param candidateClass Candidate class
     * @param candidateAlias Alias to use for the candidate in the query (if the native query supports it)
     * @return The new prototypical query statement.
     * @exception org.datanucleus.exceptions.NucleusUserException If <var>candidateClass</var> is not the same as 
     *     or a subclass of the defined element type for this collection.
     */
    QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias);

    /**
     * Returns a suitable query result factory for results produced by the specified query.
     * <p>
     * The <var>stmt</var> argument must have been obtained by a previous call
     * to newQueryStatement() on the same Queryable.
     * @param stmt The query statement
     * @param ignoreCache Whether to ignore the cache
     * @param resultClass Create objects of a particular type
     * @param useFetchPlan whether to use the fetch plan to retrieve fields in the same query
     * @return A factory for creating PersistenceCapable objects from query results.
     */
    ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan);

    /**
     * Returns <tt>true</tt> if this collection contains no elements.<p>
     * @return <tt>true</tt> if this collection contains no elements.
     */
    boolean isEmpty();
}