/**********************************************************************
Copyright (c) 2007 Thomas Marti and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.awt.geom.Arc2D;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;

/**
 * Mapping for java.awt.geom.Arc2D.Double, maps the x, y, width, height, start and extent values to double-precision 
 * datastore fields.
 */
public class Arc2dDoubleMapping extends SingleFieldMultiMapping
{
    private static final Arc2D.Double sampleValue = new Arc2D.Double();

	/* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#initialize()
     */
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr)
    {
		super.initialize(dba, fmd, container, clr);

        addDatastoreField(ClassNameConstants.INT);   // Type
        addDatastoreField(ClassNameConstants.DOUBLE); // X
        addDatastoreField(ClassNameConstants.DOUBLE); // Y
        addDatastoreField(ClassNameConstants.DOUBLE); // Width
        addDatastoreField(ClassNameConstants.DOUBLE); // Height
        addDatastoreField(ClassNameConstants.DOUBLE); // Start
        addDatastoreField(ClassNameConstants.DOUBLE); // Extent
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getJavaType()
     */
    public Class getJavaType()
    {
        return Arc2D.Double.class;
    }

    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getSampleValue()
     */
    public Object getSampleValue(ClassLoaderResolver clr)
    {
        return sampleValue;
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#setObject(org.datanucleus.ObjectManager, java.lang.Object, int[], java.lang.Object)
     */
    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value)
    {
    	Arc2D arc = (Arc2D)value;
        if (arc == null)
        {
    		for (int i = 0; i < exprIndex.length; i++) 
    		{
    			getDataStoreMapping(i).setObject(preparedStatement, exprIndex[i], null);					
			}
        }
        else
        {
            getDataStoreMapping(0).setInt(preparedStatement,exprIndex[0],arc.getArcType());
            getDataStoreMapping(1).setDouble(preparedStatement,exprIndex[1],arc.getX());
            getDataStoreMapping(2).setDouble(preparedStatement,exprIndex[2],arc.getY());
            getDataStoreMapping(3).setDouble(preparedStatement,exprIndex[3],arc.getWidth());
            getDataStoreMapping(4).setDouble(preparedStatement,exprIndex[4],arc.getHeight());
            getDataStoreMapping(5).setDouble(preparedStatement,exprIndex[5],arc.getAngleStart());
            getDataStoreMapping(6).setDouble(preparedStatement,exprIndex[6],arc.getAngleExtent());
        }
    }
    
    /* (non-Javadoc)
     * @see org.datanucleus.store.mapping.JavaTypeMapping#getObject(org.datanucleus.ObjectManager, java.lang.Object, int[])
     */
    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex)
    {
        // Check for null entries
        if (getDataStoreMapping(0).getObject(resultSet, exprIndex[0]) == null)
        {
            return null;
        }
        
        int type = getDataStoreMapping(0).getInt(resultSet,exprIndex[0]); 
        double x = getDataStoreMapping(1).getDouble(resultSet,exprIndex[1]); 
        double y = getDataStoreMapping(2).getDouble(resultSet,exprIndex[2]); 
        double width  = getDataStoreMapping(3).getDouble(resultSet,exprIndex[3]); 
        double height = getDataStoreMapping(4).getDouble(resultSet,exprIndex[4]);
        double start  = getDataStoreMapping(5).getDouble(resultSet,exprIndex[5]); 
        double extent = getDataStoreMapping(6).getDouble(resultSet,exprIndex[6]);
        return new Arc2D.Double(x, y, width, height, start, extent, type);
    }
}