package com.google.appengine.api.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/** Makes immutable copies of collections using only standard Java classes. */
public final class ImmutableCopy {
  private ImmutableCopy() {}

  /**
   * Returns an immutable List with the same contents as the given collection. The List is
   * guaranteed not to change even if the collection does.
   */
  public static <E> List<E> list(Collection<E> collection) {
    switch (collection.size()) {
      case 0:
        return Collections.emptyList();
      case 1:
        return Collections.singletonList(collection.iterator().next());
      default:
        List<E> copy = new ArrayList<>(collection.size());
        copy.addAll(collection);
        return Collections.unmodifiableList(copy);
    }
  }
}
