/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.func.fn.RegExFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public final class FnTokenize
extends RegExFn {
    private static final byte[] DEFAULT = Token.cpToken(32);
    private static final byte[] WHITESPACE = Token.token("\\s+");

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        int ch;
        byte[] pattern = this.pattern(qc);
        final byte[] value = this.input(pattern, qc);
        byte[] flags = this.toZeroToken(this.arg(2), qc);
        boolean simple = pattern == DEFAULT || flags.length == 0;
        final int vl = value.length;
        if (simple && (ch = FnTokenize.patternChar(pattern)) != -1) {
            final int sl = pattern.length;
            return vl == 0 ? Empty.ITER : new Iter(){
                int start;

                @Override
                public Item next() {
                    if (this.start == -1) {
                        return null;
                    }
                    int e = Token.indexOf(value, ch, this.start);
                    return e != -1 ? this.next(e, e + sl) : this.next(vl, -1);
                }

                private Str next(int end, int next) {
                    int b = this.start;
                    this.start = next;
                    return Str.get(Token.substring(value, b, end));
                }
            };
        }
        final Pattern p = this.pattern(pattern, flags);
        return vl == 0 ? Empty.ITER : new Iter(){
            final String string;
            final Matcher matcher;
            int start;
            {
                this.string = Token.string(value);
                this.matcher = p.matcher(this.string);
            }

            @Override
            public Item next() {
                return this.start == -1 ? null : (this.matcher.find() ? this.next(this.matcher.start(), this.matcher.end()) : this.next(this.string.length(), -1));
            }

            private Str next(int end, int next) {
                int b = this.start;
                this.start = next;
                return Str.get(Token.token(this.string.substring(b, end)));
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        int ch;
        byte[] pattern = this.pattern(qc);
        byte[] value = this.input(pattern, qc);
        byte[] flags = this.toZeroToken(this.arg(2), qc);
        boolean simple = pattern == DEFAULT || flags.length == 0;
        int vl = value.length;
        if (simple && (ch = FnTokenize.patternChar(pattern)) != -1) {
            return vl == 0 ? Empty.VALUE : StrSeq.get(Token.split(value, ch, true));
        }
        Pattern p = this.pattern(pattern, flags);
        if (vl == 0) {
            return Empty.VALUE;
        }
        TokenList tl = new TokenList();
        String string = Token.string(value);
        int len = string.length();
        int start = 0;
        Matcher matcher = p.matcher(string);
        while (matcher.find()) {
            int ms = matcher.start();
            int me = matcher.end();
            if (ms == len || me == 0) continue;
            tl.add(string.substring(start, ms));
            start = me;
        }
        return StrSeq.get(tl.add(string.substring(start)));
    }

    private byte[] pattern(QueryContext qc) throws QueryException {
        byte[] pattern = this.toTokenOrNull(this.arg(1), qc);
        return pattern != null ? pattern : DEFAULT;
    }

    private byte[] input(byte[] pattern, QueryContext qc) throws QueryException {
        byte[] value = this.toZeroToken(this.arg(0), qc);
        return pattern == DEFAULT ? Token.normalize(value) : value;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Str str;
        Expr value = this.arg(0);
        Expr pattern = this.arg(1);
        if (Function.NORMALIZE_SPACE.is(value) && pattern instanceof Str && Token.eq((str = (Str)pattern).string(), Token.cpToken(32))) {
            Expr arg = value.args().length == 1 ? value.arg(0) : ContextValue.get(cc, this.info);
            return cc.function(Function.TOKENIZE, this.info, arg);
        }
        return this;
    }

    public boolean whitespace() {
        Str str;
        Expr pattern = this.arg(1);
        return pattern == Empty.VALUE || pattern == Empty.UNDEFINED || pattern instanceof Str && Token.eq((str = (Str)pattern).string(), WHITESPACE);
    }
}

