/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Util;

public final class Performance {
    private long time = System.nanoTime();

    public long nanoRuntime() {
        return this.nanoRuntime(true);
    }

    public long nanoRuntime(boolean reset) {
        long time2 = System.nanoTime();
        long diff = time2 - this.time;
        if (reset) {
            this.time = time2;
        }
        return diff;
    }

    public String formatRuntime() {
        return this.formatRuntime(1);
    }

    public String formatRuntime(int runs) {
        long time2 = System.nanoTime();
        String t = Performance.formatNano(time2 - this.time, runs);
        this.time = time2;
        return t;
    }

    public static double nanoToMilli(long nano) {
        return Performance.nanoToMilli(nano, 1);
    }

    public static double nanoToMilli(long nano, int runs) {
        return (double)Math.round((double)nano / 10000.0 / (double)runs) / 100.0;
    }

    public static String formatNano(long nano) {
        return Performance.formatNano(nano, 1);
    }

    public static String formatNano(long nano, int runs) {
        return Performance.nanoToMilli(nano, runs) + " ms" + (runs > 1 ? " (avg)" : "");
    }

    public static String formatMemory() {
        return Performance.formatHuman(Performance.memory());
    }

    public static String formatHuman(long size) {
        String value = Long.toString(size);
        int vl = value.length();
        return vl > 16 ? Performance.units(size, 0x10000000000L) + " PB" : (vl > 13 ? Performance.units(size, 0x10000000000L) + " TB" : (vl > 10 ? Performance.units(size, 0x40000000L) + " GB" : (vl > 7 ? Performance.units(size, 0x100000L) + " MB" : (vl > 4 ? Performance.units(size, 1024L) + " kB" : value + " b"))));
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(Math.max(0L, ms));
        }
        catch (InterruptedException ex) {
            Util.debug(ex);
        }
    }

    public static void gc(int count) {
        for (int c = 0; c < count; ++c) {
            System.gc();
        }
    }

    public static long memory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    private static long units(long number, long size) {
        return (number + size - 1L) / size;
    }

    public String toString() {
        return this.formatRuntime();
    }
}

