/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.map;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.util.hash.ItemObjectMap;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQHashMap;
import org.basex.query.value.seq.ItemSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.Types;

public final class XQItemValueMap
extends XQHashMap {
    private final ItemObjectMap<Value> map;

    XQItemValueMap(int capacity) {
        super(Types.MAP);
        this.map = new ItemObjectMap(capacity);
    }

    @Override
    public long structSize() {
        return this.map.size();
    }

    @Override
    public Value getOrNull(Item key) throws QueryException {
        return this.map.get(key);
    }

    @Override
    public Value keys() {
        return ItemSeq.get(this.map.keys(), (int)this.structSize(), ((MapType)this.type).keyType());
    }

    @Override
    public Item keyAt(int index) {
        return this.map.key(index + 1);
    }

    @Override
    public Value valueAt(int index) {
        return this.map.value(index + 1);
    }

    @Override
    void valueAt(int index, Value value) {
        this.map.value(index + 1, value);
    }

    @Override
    XQHashMap build(Item key, Value value) throws QueryException {
        this.map.put(key, value);
        return this;
    }

    @Override
    public Item shrink(QueryContext qc) throws QueryException {
        this.shrinkValues(qc);
        this.refineType();
        return ((MapType)this.type).keyType().oneOf(AtomType.INTEGER, AtomType.STRING, AtomType.UNTYPED_ATOMIC) ? this.rebuild(qc) : this;
    }
}

