/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import org.basex.io.IO;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveCreate;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;

public final class ArchiveRefresh
extends ArchiveCreate {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        IO io = this.toIO(this.arg(0), qc);
        Map<String, Map.Entry<Item, Item>> files = this.toFiles(this.arg(1), this.arg(2), qc);
        try {
            if (!ArchiveRefresh.localZip(io)) {
                throw QueryError.ARCHIVE_ZIP_X.get(this.info, io);
            }
            try (FileSystem fs = FileSystems.newFileSystem(Paths.get(io.path(), new String[0]), (ClassLoader)null);){
                for (Map.Entry<String, Map.Entry<Item, Item>> file : files.entrySet()) {
                    Path path = fs.getPath(file.getKey(), new String[0]);
                    Map.Entry<Item, Item> entry = file.getValue();
                    Item header = entry.getKey();
                    Item content = entry.getValue();
                    if (content == XQArray.empty()) {
                        if (!Files.exists(path, new LinkOption[0])) continue;
                        Files.delete(path);
                        continue;
                    }
                    if (content instanceof Bin) {
                        Bin bin = (Bin)content;
                        Files.copy(bin.input(this.info), path, StandardCopyOption.REPLACE_EXISTING);
                    } else {
                        Files.write(path, this.encode(this.toBytes(content, qc), this.encoding(header), false, qc), new OpenOption[0]);
                    }
                    long time = this.timestamp(header, qc);
                    FileTime ft = FileTime.fromMillis(time < 0L ? System.currentTimeMillis() : time);
                    Files.setLastModifiedTime(path, ft);
                }
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(this.info, ex);
        }
        return Empty.VALUE;
    }
}

