/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.tools.bt;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.function.BiConsumer;

public class HexDumper {
    private PrintStream ps = System.out;
    private int lineWidth = 16;
    private BiConsumer<Integer, Integer> printHeader;
    private BiConsumer<Integer, byte[]> printLine;

    public static HexDumper standard() {
        HexDumper hd = new HexDumper();
        hd.printHeader = (arg_0, arg_1) -> hd.emptyHeader(arg_0, arg_1);
        hd.printLine = (arg_0, arg_1) -> hd.standardLine(arg_0, arg_1);
        return hd;
    }

    public static HexDumper apple2() {
        HexDumper hd = new HexDumper();
        hd.printHeader = (arg_0, arg_1) -> hd.apple2Header(arg_0, arg_1);
        hd.printLine = (arg_0, arg_1) -> hd.apple2Line(arg_0, arg_1);
        return hd;
    }

    public void dump(int address, byte[] data) {
        byte[] line;
        this.printHeader.accept(address, data.length);
        for (int offset = 0; offset < data.length; offset += line.length) {
            line = Arrays.copyOfRange(data, offset, Math.min(offset + this.lineWidth, data.length));
            this.printLine.accept(address + offset, line);
        }
    }

    public void emptyHeader(int address, int length) {
    }

    public void apple2Header(int address, int length) {
        int end = address + length;
        this.printLine.accept(103, new byte[]{(byte)(address & 0xFF), (byte)(address >> 8), (byte)(end & 0xFF), (byte)(end >> 8)});
        this.printLine.accept(address - 1, new byte[]{0});
    }

    public void standardLine(int address, byte[] data) {
        int i;
        this.ps.printf("%04x: ", address);
        for (i = 0; i < this.lineWidth; ++i) {
            if (i < data.length) {
                this.ps.printf("%02x ", data[i]);
                continue;
            }
            this.ps.printf(".. ", new Object[0]);
        }
        this.ps.print(" ");
        for (i = 0; i < this.lineWidth; ++i) {
            char ch = ' ';
            if (i < data.length) {
                byte b = data[i];
                ch = (char)(b >= 32 ? (int)b : 46);
            }
            this.ps.printf("%c", Character.valueOf(ch));
        }
        this.ps.printf("\n", new Object[0]);
    }

    public void apple2Line(int address, byte[] data) {
        this.ps.printf("%04X:", address);
        for (byte b : data) {
            this.ps.printf("%02X ", b);
        }
        this.ps.printf("\n", new Object[0]);
    }
}

