/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import javax.tools.JavaFileManager;

public class Main {
    String ownName;
    PrintWriter stdOut;
    PrintWriter stdErr;
    public Log log;
    boolean apiMode;
    private static final String ENV_OPT_NAME = "JDK_JAVAC_OPTIONS";
    private JavaFileManager fileManager;
    public static final String javacBundleName = "com.sun.tools.javac.resources.javac";

    public Main(String name) {
        this.ownName = name;
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.stdOut = this.stdErr = out;
    }

    public Main(String name, PrintWriter out, PrintWriter err) {
        this.ownName = name;
        this.stdOut = out;
        this.stdErr = err;
    }

    void error(String key, Object ... args) {
        if (this.apiMode) {
            String msg = this.log.localize(Log.PrefixKind.JAVAC, key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.usage", this.ownName);
    }

    void warning(String key, Object ... args) {
        this.log.printRawLines(this.ownName + ": " + this.log.localize(Log.PrefixKind.JAVAC, key, args));
    }

    public Result compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        Result result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            try {
                ((JavacFileManager)this.fileManager).close();
            }
            catch (IOException ex) {
                this.bugMessage(ex);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result compile(String[] argv, Context context) {
        Object t;
        Set<List<String>> pluginOpts;
        String showClass;
        boolean batchMode;
        if (this.stdOut != null) {
            context.put(Log.outKey, this.stdOut);
        }
        if (this.stdErr != null) {
            context.put(Log.errKey, this.stdErr);
        }
        this.log = Log.instance(context);
        if (argv.length == 0) {
            OptionHelper.GrumpyHelper h = new OptionHelper.GrumpyHelper(this.log){

                @Override
                public String getOwnName() {
                    return Main.this.ownName;
                }

                @Override
                public void put(String name, String value) {
                }
            };
            try {
                Option.HELP.process(h, "-help");
            }
            catch (Option.InvalidValueException invalidValueException) {
                // empty catch block
            }
            return Result.CMDERR;
        }
        try {
            argv = CommandLine.parse(ENV_OPT_NAME, argv);
        }
        catch (CommandLine.UnmatchedQuote ex) {
            this.error("err.unmatched.quote", ex.variableName);
            return Result.CMDERR;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.warning("err.file.not.found", e.getMessage());
            return Result.SYSERR;
        }
        catch (IOException ex) {
            this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
            ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
            return Result.SYSERR;
        }
        Arguments args = Arguments.instance(context);
        args.init(this.ownName, argv);
        if (this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        Options options = Options.instance(context);
        boolean forceStdOut = options.isSet("stdout");
        if (forceStdOut) {
            this.log.flush();
            this.log.setWriters(new PrintWriter(System.out, true));
        }
        boolean bl = batchMode = options.isUnset("nonBatchMode") && System.getProperty("nonBatchMode") == null;
        if (batchMode) {
            CacheFSInfo.preRegister(context);
        }
        boolean ok = true;
        this.fileManager = context.get(JavaFileManager.class);
        if (this.fileManager instanceof BaseFileManager) {
            ((BaseFileManager)this.fileManager).setContext(context);
            ok &= ((BaseFileManager)this.fileManager).handleOptions(args.getDeferredFileManagerOptions());
        }
        if ((showClass = options.get("showClass")) != null) {
            if (showClass.equals("showClass")) {
                showClass = "com.sun.tools.javac.Main";
            }
            this.showClass(showClass);
        }
        if (!(ok &= args.validate()) || this.log.nerrors > 0) {
            return Result.CMDERR;
        }
        if (args.isEmpty()) {
            return Result.OK;
        }
        if (options.isSet("debug.completionDeps")) {
            Dependencies.GraphDependencies.preRegister(context);
        }
        if (!(pluginOpts = args.getPluginOpts()).isEmpty() || context.get(PlatformDescription.class) != null) {
            BasicJavacTask t2 = (BasicJavacTask)BasicJavacTask.instance(context);
            t2.initPlugins(pluginOpts);
        }
        if (this.fileManager.isSupportedOption(Option.MULTIRELEASE.primaryName) == 1) {
            Target target = Target.instance(context);
            List<String> list = List.of(target.multiReleaseValue());
            this.fileManager.handleOption(Option.MULTIRELEASE.primaryName, list.iterator());
        }
        JavaCompiler comp = JavaCompiler.instance(context);
        List<String> docLintOpts = args.getDocLintOpts();
        if (!docLintOpts.isEmpty()) {
            t = (BasicJavacTask)BasicJavacTask.instance(context);
            t.initDocLint(docLintOpts);
        }
        if (options.get(Option.XSTDOUT) != null) {
            comp.closeables = comp.closeables.prepend(this.log.getWriter(Log.WriterKind.NOTICE));
        }
        try {
            comp.compile(args.getFileObjects(), args.getClassNames(), null, List.nil());
            if (this.log.expectDiagKeys != null) {
                if (this.log.expectDiagKeys.isEmpty()) {
                    this.log.printRawLines("all expected diagnostics found");
                    t = Result.OK;
                    return t;
                }
                this.log.printRawLines("expected diagnostic keys not found: " + this.log.expectDiagKeys);
                t = Result.ERROR;
                return t;
            }
            t = comp.errorCount() == 0 ? Result.OK : Result.ERROR;
            return t;
        }
        catch (OutOfMemoryError | StackOverflowError ex) {
            this.resourceMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (FatalError ex) {
            this.feMessage(ex, options);
            Result result = Result.SYSERR;
            return result;
        }
        catch (AnnotationProcessingError ex) {
            this.apMessage(ex);
            Result result = Result.SYSERR;
            return result;
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (Throwable ex) {
            if (comp == null || comp.errorCount() == 0 || options.isSet("dev")) {
                this.bugMessage(ex);
            }
            Result result = Result.ABNORMAL;
            return result;
        }
        finally {
            if (comp != null) {
                try {
                    comp.close();
                }
                catch (ClientCodeException ex) {
                    throw new RuntimeException(ex.getCause());
                }
            }
        }
    }

    void bugMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.bug", JavaCompiler.version());
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void feMessage(Throwable ex, Options options) {
        this.log.printRawLines(ex.getMessage());
        if (ex.getCause() != null && options.isSet("dev")) {
            ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
        }
    }

    void ioMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.io", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void resourceMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.resource", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void apMessage(AnnotationProcessingError ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.proc.annotation.uncaught.exception", new Object[0]);
        ex.getCause().printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void pluginMessage(Throwable ex) {
        this.log.printLines(Log.PrefixKind.JAVAC, "msg.plugin.uncaught.exception", new Object[0]);
        ex.printStackTrace(this.log.getWriter(Log.WriterKind.NOTICE));
    }

    void showClass(String className) {
        PrintWriter pw = this.log.getWriter(Log.WriterKind.NOTICE);
        pw.println("javac: show class: " + className);
        URL url = this.getClass().getResource("/" + className.replace('.', '/') + ".class");
        if (url != null) {
            pw.println("  " + url);
        }
        try (InputStream in = this.getClass().getResourceAsStream("/" + className.replace('.', '/') + ".class");){
            byte[] digest;
            String algorithm = "MD5";
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream din = new DigestInputStream(in, md);
            Object object = null;
            try {
                int n;
                byte[] buf = new byte[8192];
                while ((n = din.read(buf)) > 0) {
                }
                digest = md.digest();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                Main.$closeResource((Throwable)object, din);
            }
            StringBuilder sb = new StringBuilder();
            for (Object b : (Object)digest) {
                sb.append(String.format("%02x", (byte)b));
            }
            pw.println("  MD5 checksum: " + sb);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            pw.println("  cannot compute digest: " + e);
        }
    }

    public static enum Result {
        OK(0),
        ERROR(1),
        CMDERR(2),
        SYSERR(3),
        ABNORMAL(4);

        public final int exitCode;

        private Result(int exitCode) {
            this.exitCode = exitCode;
        }

        public boolean isOK() {
            return this.exitCode == 0;
        }
    }
}

