/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.options;

import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.options.Option;
import com.sun.tools.sjavac.options.OptionHelper;
import com.sun.tools.sjavac.options.SourceLocation;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class Options {
    private Path destDir;
    private Path genSrcDir;
    private Path headerDir;
    private Path stateDir;
    private List<SourceLocation> sources = new ArrayList<SourceLocation>();
    private List<SourceLocation> sourceSearchPaths = new ArrayList<SourceLocation>();
    private List<SourceLocation> classSearchPaths = new ArrayList<SourceLocation>();
    private List<SourceLocation> moduleSearchPaths = new ArrayList<SourceLocation>();
    private String logLevel = "info";
    private Set<String> permitted_artifacts = new HashSet<String>();
    private boolean permitUnidentifiedArtifacts = false;
    private boolean permitSourcesInDefaultPackage = false;
    private Path sourceReferenceList;
    private int numCores = 4;
    private String implicitPolicy = "none";
    private List<String> javacArgs = new ArrayList<String>();
    private Map<String, Transformer> trRules = new HashMap<String, Transformer>();
    private boolean startServer = false;
    private String serverConf;

    public String getImplicitPolicy() {
        return this.implicitPolicy;
    }

    public Path getGenSrcDir() {
        return this.genSrcDir;
    }

    public Path getDestDir() {
        return this.destDir;
    }

    public Path getHeaderDir() {
        return this.headerDir;
    }

    public Path getStateDir() {
        return this.stateDir;
    }

    public List<SourceLocation> getSources() {
        return this.sources;
    }

    public List<SourceLocation> getSourceSearchPaths() {
        return this.sourceSearchPaths;
    }

    public List<SourceLocation> getClassSearchPath() {
        return this.classSearchPaths;
    }

    public List<SourceLocation> getModuleSearchPaths() {
        return this.moduleSearchPaths;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isUnidentifiedArtifactPermitted(String string) {
        return this.permitted_artifacts.contains(string);
    }

    public boolean areUnidentifiedArtifactsPermitted() {
        return this.permitUnidentifiedArtifacts;
    }

    public boolean isDefaultPackagePermitted() {
        return this.permitSourcesInDefaultPackage;
    }

    public Path getSourceReferenceList() {
        return this.sourceReferenceList;
    }

    public int getNumCores() {
        return this.numCores;
    }

    public List<String> getJavacArgs() {
        return this.javacArgs;
    }

    public Map<String, Transformer> getTranslationRules() {
        return this.trRules;
    }

    public boolean startServerFlag() {
        return this.startServer;
    }

    public String getServerConf() {
        return this.serverConf;
    }

    public static Options parseArgs(String ... stringArray) {
        Options options;
        Options options2 = options = new Options();
        options2.getClass();
        options2.new ArgDecoderOptionHelper().traverse(stringArray);
        return options;
    }

    public boolean isJavaFilesAmongJavacArgs() {
        for (String string : this.javacArgs) {
            if (!string.endsWith(".java")) continue;
            return true;
        }
        return false;
    }

    public String getStateArgsString() {
        class StateArgs {
            private List<String> args = new ArrayList<String>();

            StateArgs() {
            }

            void addArg(Option option) {
                this.args.add(option.arg);
            }

            void addArg(Option option, Object object) {
                this.addArg(option);
                this.args.add(object.toString());
            }

            void addSourceLocations(Option option, List<SourceLocation> list) {
                for (SourceLocation sourceLocation : list) {
                    for (String string : sourceLocation.includes) {
                        this.addArg(Option.I, string);
                    }
                    for (String string : sourceLocation.excludes) {
                        this.addArg(Option.X, string);
                    }
                    this.addArg(option, sourceLocation.getPath());
                }
            }

            String getResult() {
                return String.join((CharSequence)" ", this.args);
            }

            public void addAll(Collection<String> collection) {
                this.args.addAll(collection);
            }
        }
        StateArgs stateArgs = new StateArgs();
        if (this.genSrcDir != null) {
            stateArgs.addArg(Option.S, this.genSrcDir.normalize());
        }
        if (this.headerDir != null) {
            stateArgs.addArg(Option.H, this.headerDir.normalize());
        }
        if (this.destDir != null) {
            stateArgs.addArg(Option.D, this.destDir.normalize());
        }
        if (this.stateDir != null) {
            stateArgs.addArg(Option.STATE_DIR, this.stateDir.normalize());
        }
        stateArgs.addSourceLocations(Option.SRC, this.sources);
        stateArgs.addSourceLocations(Option.SOURCE_PATH, this.sourceSearchPaths);
        stateArgs.addSourceLocations(Option.CLASS_PATH, this.classSearchPaths);
        stateArgs.addSourceLocations(Option.MODULE_PATH, this.moduleSearchPaths);
        if (this.permitSourcesInDefaultPackage) {
            stateArgs.addArg(Option.PERMIT_SOURCES_WITHOUT_PACKAGE);
        }
        for (String object : this.permitted_artifacts) {
            stateArgs.addArg(Option.PERMIT_ARTIFACT, object);
        }
        if (this.permitUnidentifiedArtifacts) {
            stateArgs.addArg(Option.PERMIT_UNIDENTIFIED_ARTIFACTS);
        }
        for (Map.Entry entry : this.trRules.entrySet()) {
            String string = (String)entry.getKey() + "=" + ((Transformer)entry.getValue()).getClass().getName();
            stateArgs.addArg(Option.TR, string);
        }
        stateArgs.addAll(this.javacArgs);
        return stateArgs.getResult();
    }

    public String[] prepJavacArgs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-d");
        arrayList.add(this.destDir.toString());
        if (this.getGenSrcDir() != null) {
            arrayList.add("-s");
            arrayList.add(this.genSrcDir.toString());
        }
        if (this.headerDir != null) {
            arrayList.add("-h");
            arrayList.add(this.headerDir.toString());
        }
        ArrayList<SourceLocation> arrayList2 = new ArrayList<SourceLocation>();
        arrayList2.addAll(this.sources);
        arrayList2.addAll(this.sourceSearchPaths);
        if (arrayList2.size() > 0) {
            arrayList.add("-sourcepath");
            arrayList.add(Options.concatenateSourceLocations(arrayList2));
        }
        if (this.classSearchPaths.size() > 0) {
            arrayList.add("-classpath");
            arrayList.add(Options.concatenateSourceLocations(this.classSearchPaths));
        }
        arrayList.add("--debug:completionDeps=source,class");
        arrayList.add("-implicit:" + this.implicitPolicy);
        arrayList.addAll(this.javacArgs);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String concatenateSourceLocations(List<SourceLocation> list) {
        StringJoiner stringJoiner = new StringJoiner(File.pathSeparator);
        for (SourceLocation sourceLocation : list) {
            stringJoiner.add(sourceLocation.getPath().toString());
        }
        return stringJoiner.toString();
    }

    private class ArgDecoderOptionHelper
    extends OptionHelper {
        List<String> includes;
        List<String> excludes;
        List<String> includeFiles;
        List<String> excludeFiles;
        boolean headerProvided;
        boolean genSrcProvided;
        boolean stateProvided;

        private ArgDecoderOptionHelper() {
            this.resetFilters();
            this.headerProvided = false;
            this.genSrcProvided = false;
            this.stateProvided = false;
        }

        @Override
        public void reportError(String string) {
            throw new IllegalArgumentException(string);
        }

        @Override
        public void sourceRoots(List<Path> list) {
            Options.this.sources.addAll(this.createSourceLocations(list));
        }

        @Override
        public void exclude(String string) {
            string = Util.normalizeDriveLetter(string);
            this.excludes.add(string);
        }

        @Override
        public void include(String string) {
            string = Util.normalizeDriveLetter(string);
            this.includes.add(string);
        }

        @Override
        public void addTransformer(String string, Transformer transformer) {
            if (Options.this.trRules.containsKey(string)) {
                this.reportError("More than one transformer specified for suffix " + string + ".");
                return;
            }
            Options.this.trRules.put(string, transformer);
        }

        @Override
        public void sourcepath(List<Path> list) {
            Options.this.sourceSearchPaths.addAll(this.createSourceLocations(list));
        }

        @Override
        public void modulepath(List<Path> list) {
            Options.this.moduleSearchPaths.addAll(this.createSourceLocations(list));
        }

        @Override
        public void classpath(List<Path> list) {
            Options.this.classSearchPaths.addAll(this.createSourceLocations(list));
        }

        @Override
        public void numCores(int n) {
            Options.this.numCores = n;
        }

        @Override
        public void logLevel(String string) {
            Options.this.logLevel = string;
        }

        @Override
        public void compareFoundSources(Path path) {
            Options.this.sourceReferenceList = path;
        }

        @Override
        public void permitArtifact(String string) {
            Options.this.permitted_artifacts.add(string);
        }

        @Override
        public void permitUnidentifiedArtifacts() {
            Options.this.permitUnidentifiedArtifacts = true;
        }

        @Override
        public void permitDefaultPackage() {
            Options.this.permitSourcesInDefaultPackage = true;
        }

        @Override
        public void serverConf(String string) {
            if (Options.this.serverConf != null) {
                this.reportError("Can not specify more than one server configuration.");
            } else {
                Options.this.serverConf = string;
            }
        }

        @Override
        public void implicit(String string) {
            Options.this.implicitPolicy = string;
        }

        @Override
        public void startServerConf(String string) {
            if (Options.this.serverConf != null) {
                this.reportError("Can not specify more than one server configuration.");
            } else {
                Options.this.startServer = true;
                Options.this.serverConf = string;
            }
        }

        @Override
        public void javacArg(String ... stringArray) {
            Options.this.javacArgs.addAll(Arrays.asList(stringArray));
        }

        @Override
        public void destDir(Path path) {
            if (Options.this.destDir != null) {
                this.reportError("Destination directory already specified.");
                return;
            }
            Options.this.destDir = path.toAbsolutePath();
        }

        @Override
        public void generatedSourcesDir(Path path) {
            if (this.genSrcProvided) {
                this.reportError("Directory for generated sources already specified.");
                return;
            }
            this.genSrcProvided = true;
            Options.this.genSrcDir = path.toAbsolutePath();
        }

        @Override
        public void headerDir(Path path) {
            if (this.headerProvided) {
                this.reportError("Header directory already specified.");
                return;
            }
            this.headerProvided = true;
            Options.this.headerDir = path.toAbsolutePath();
        }

        @Override
        public void stateDir(Path path) {
            if (this.stateProvided) {
                this.reportError("State directory already specified.");
                return;
            }
            this.stateProvided = true;
            Options.this.stateDir = path.toAbsolutePath();
        }

        private List<SourceLocation> createSourceLocations(List<Path> list) {
            ArrayList<SourceLocation> arrayList = new ArrayList<SourceLocation>();
            for (Path path : list) {
                arrayList.add(new SourceLocation(path, this.includes, this.excludes));
            }
            this.resetFilters();
            return arrayList;
        }

        private void resetFilters() {
            this.includes = new ArrayList<String>();
            this.excludes = new ArrayList<String>();
            this.includeFiles = new ArrayList<String>();
            this.excludeFiles = new ArrayList<String>();
        }
    }
}

