/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.TreeUtils;

public class TernaryExpressionNode
extends Node {
    protected final ConditionalExpressionTree tree;
    protected final Node condition;
    protected final Node thenOperand;
    protected final Node elseOperand;

    public TernaryExpressionNode(ConditionalExpressionTree tree, Node condition, Node thenOperand, Node elseOperand) {
        super(TreeUtils.typeOf((Tree)tree));
        assert (tree.getKind().equals((Object)Tree.Kind.CONDITIONAL_EXPRESSION));
        this.tree = tree;
        this.condition = condition;
        this.thenOperand = thenOperand;
        this.elseOperand = elseOperand;
    }

    public Node getConditionOperand() {
        return this.condition;
    }

    public Node getThenOperand() {
        return this.thenOperand;
    }

    public Node getElseOperand() {
        return this.elseOperand;
    }

    @Override
    public ConditionalExpressionTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitTernaryExpression(this, p);
    }

    public String toString() {
        return "(" + this.getConditionOperand() + " ? " + this.getThenOperand() + " : " + this.getElseOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TernaryExpressionNode)) {
            return false;
        }
        TernaryExpressionNode other = (TernaryExpressionNode)obj;
        return this.getConditionOperand().equals(other.getConditionOperand()) && this.getThenOperand().equals(other.getThenOperand()) && this.getElseOperand().equals(other.getElseOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash(this.getConditionOperand(), this.getThenOperand(), this.getElseOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        ArrayList<Node> list = new ArrayList<Node>(3);
        list.add(this.getConditionOperand());
        list.add(this.getThenOperand());
        list.add(this.getElseOperand());
        return list;
    }
}

