/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.testing.api;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public interface DeviceConfig {
    public Optional<String> getValue(Catetory var1);

    public List<String> getAbis();

    public String getConfigForAllAbis();

    public String getConfigFor(String var1);

    public static class Builder {
        public static DeviceConfig parse(Collection<String> lines) {
            ImmutableList.Builder valuesBuilder = ImmutableList.builder();
            for (String line : lines) {
                for (Catetory catetory : Catetory.values()) {
                    String key = catetory.name().toLowerCase(Locale.US) + ": ";
                    if (!line.startsWith(key)) continue;
                    valuesBuilder.add((Object)new Values(catetory, line.substring(key.length())));
                }
            }
            final ImmutableList values = valuesBuilder.build();
            return new DeviceConfig(){

                @Override
                public Optional<String> getValue(Catetory catetory) {
                    for (Values value : values) {
                        if (!value.mCatetory.equals((Object)catetory)) continue;
                        return Optional.of((Object)value.value);
                    }
                    return Optional.absent();
                }

                @Override
                public List<String> getAbis() {
                    ImmutableList.Builder abiBuilder = ImmutableList.builder();
                    Optional<String> abis = this.getValue(Catetory.ABI);
                    if (abis.isPresent()) {
                        StringTokenizer stringTokenizer = new StringTokenizer((String)abis.get(), ",");
                        while (stringTokenizer.hasMoreElements()) {
                            abiBuilder.add((Object)stringTokenizer.nextToken());
                        }
                    }
                    return abiBuilder.build();
                }

                @Override
                public String getConfigForAllAbis() {
                    StringBuilder completeConfig = new StringBuilder();
                    Optional<String> config = this.getValue(Catetory.CONFIG);
                    List<String> abis = this.getAbis();
                    if (abis.isEmpty() && config.isPresent()) {
                        completeConfig.append((String)config.get());
                    } else {
                        if (config.isPresent()) {
                            completeConfig.append((String)config.get());
                            completeConfig.append(":");
                        }
                        Joiner.on((String)",").appendTo(completeConfig, abis);
                    }
                    return completeConfig.toString();
                }

                @Override
                public String getConfigFor(String abi) {
                    StringBuilder completeConfig = new StringBuilder();
                    Optional<String> config = this.getValue(Catetory.CONFIG);
                    if (config.isPresent()) {
                        completeConfig.append((String)config.get());
                        if (!Strings.isNullOrEmpty((String)abi)) {
                            completeConfig.append(":");
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)abi)) {
                        completeConfig.append(abi);
                    }
                    return completeConfig.toString();
                }
            };
        }

        private static class Values {
            private final Catetory mCatetory;
            private final String value;

            private Values(Catetory catetory, String value) {
                this.mCatetory = catetory;
                this.value = value;
            }
        }
    }

    public static enum Catetory {
        CONFIG,
        ABI;

    }
}

