/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractExpectedExceptionChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;
import javax.annotation.Nullable;

@BugPattern(name="ExpectedExceptionRefactoring", category=BugPattern.Category.JUNIT, summary="Prefer assertThrows to ExpectedException", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Refactoring"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ExpectedExceptionRefactoring
extends AbstractExpectedExceptionChecker
implements BugChecker.VariableTreeMatcher {
    @Override
    protected Description handleMatch(MethodTree tree, VisitorState state, List<Tree> expectations, List<StatementTree> suffix, @Nullable StatementTree failure) {
        return this.describeMatch(tree, this.buildBaseFix(state, expectations, failure).build(suffix));
    }

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Symbol)ASTHelpers.getSymbol((VariableTree)tree), (String)"org.junit.Rule", (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree), (Type)state.getTypeFromString("org.junit.rules.ExpectedException"), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.delete((Tree)tree));
    }
}

