/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.type.DeclaredType;

public abstract class Attribute
implements AnnotationValue {
    public Type type;

    public Attribute(Type type) {
        this.type = type;
    }

    public abstract void accept(Visitor var1);

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
        throw new UnsupportedOperationException();
    }

    public boolean isSynthesized() {
        return false;
    }

    public TypeAnnotationPosition getPosition() {
        return null;
    }

    public static enum RetentionPolicy {
        SOURCE,
        CLASS,
        RUNTIME;

    }

    public static interface Visitor {
        public void visitConstant(Constant var1);

        public void visitClass(Class var1);

        public void visitCompound(Compound var1);

        public void visitArray(Array var1);

        public void visitEnum(Enum var1);

        public void visitError(Error var1);
    }

    public static class UnresolvedClass
    extends Error {
        public Type classType;

        public UnresolvedClass(Type type, Type type2) {
            super(type);
            this.classType = type2;
        }
    }

    public static class Error
    extends Attribute {
        public Error(Type type) {
            super(type);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitError(this);
        }

        @Override
        public String toString() {
            return "<error>";
        }

        @Override
        public String getValue() {
            return this.toString();
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitString(this.toString(), p);
        }
    }

    public static class Enum
    extends Attribute {
        public Symbol.VarSymbol value;

        public Enum(Type type, Symbol.VarSymbol varSymbol) {
            super(type);
            this.value = Assert.checkNonNull(varSymbol);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitEnum(this);
        }

        @Override
        public String toString() {
            return this.value.enclClass() + "." + this.value;
        }

        @Override
        public Symbol.VarSymbol getValue() {
            return this.value;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitEnumConstant(this.value, p);
        }
    }

    public static class Array
    extends Attribute {
        public final Attribute[] values;

        public Array(Type type, Attribute[] attributeArray) {
            super(type);
            this.values = attributeArray;
        }

        public Array(Type type, List<Attribute> list) {
            super(type);
            this.values = list.toArray(new Attribute[list.size()]);
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitArray(this);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('{');
            boolean bl = true;
            for (Attribute attribute : this.values) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                stringBuilder.append(attribute);
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        @Override
        public List<Attribute> getValue() {
            return List.from(this.values);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitArray((java.util.List<AnnotationValue>)this.getValue(), p);
        }

        @Override
        public TypeAnnotationPosition getPosition() {
            if (this.values.length != 0) {
                return this.values[0].getPosition();
            }
            return null;
        }
    }

    public static class TypeCompound
    extends Compound {
        public TypeCompound(Compound compound, TypeAnnotationPosition typeAnnotationPosition) {
            super(compound.type, compound.values, typeAnnotationPosition);
        }

        public TypeCompound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> list, TypeAnnotationPosition typeAnnotationPosition) {
            super(type, list, typeAnnotationPosition);
        }
    }

    public static class Compound
    extends Attribute
    implements AnnotationMirror {
        public final List<Pair<Symbol.MethodSymbol, Attribute>> values;
        public TypeAnnotationPosition position;
        private boolean synthesized = false;

        @Override
        public boolean isSynthesized() {
            return this.synthesized;
        }

        public void setSynthesized(boolean bl) {
            this.synthesized = bl;
        }

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> list, TypeAnnotationPosition typeAnnotationPosition) {
            super(type);
            this.values = list;
            this.position = typeAnnotationPosition;
        }

        public Compound(Type type, List<Pair<Symbol.MethodSymbol, Attribute>> list) {
            this(type, list, null);
        }

        @Override
        public TypeAnnotationPosition getPosition() {
            if (this.hasUnknownPosition() && this.values.size() != 0) {
                Name name = ((Symbol.MethodSymbol)((Pair)this.values.head).fst).name.table.names.value;
                Pair<Symbol.MethodSymbol, Attribute> pair = this.getElemPair(name);
                this.position = pair == null ? null : ((Attribute)pair.snd).getPosition();
            }
            return this.position;
        }

        public boolean isContainerTypeCompound() {
            if (this.isSynthesized() && this.values.size() == 1) {
                return this.getFirstEmbeddedTC() != null;
            }
            return false;
        }

        private Compound getFirstEmbeddedTC() {
            if (this.values.size() == 1) {
                Pair<Symbol.MethodSymbol, Attribute> pair = this.values.get(0);
                if (((Name)((Symbol.MethodSymbol)pair.fst).getSimpleName()).contentEquals("value") && pair.snd instanceof Array) {
                    Array array = (Array)pair.snd;
                    if (array.values.length != 0 && array.values[0] instanceof TypeCompound) {
                        return (TypeCompound)array.values[0];
                    }
                }
            }
            return null;
        }

        public boolean tryFixPosition() {
            if (!this.isContainerTypeCompound()) {
                return false;
            }
            Compound compound = this.getFirstEmbeddedTC();
            if (compound != null && compound.position != null && compound.position.type != TargetType.UNKNOWN) {
                this.position = compound.position;
                return true;
            }
            return false;
        }

        public boolean hasUnknownPosition() {
            return this.position.type == TargetType.UNKNOWN;
        }

        @Override
        public void accept(Visitor visitor) {
            visitor.visitCompound(this);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@");
            stringBuilder.append(this.type);
            int n = this.values.length();
            if (n > 0) {
                stringBuilder.append('(');
                boolean bl = true;
                for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                    if (!bl) {
                        stringBuilder.append(", ");
                    }
                    bl = false;
                    Name name = ((Symbol.MethodSymbol)pair.fst).name;
                    if (n > 1 || name != name.table.names.value) {
                        stringBuilder.append(name);
                        stringBuilder.append('=');
                    }
                    stringBuilder.append(pair.snd);
                }
                stringBuilder.append(')');
            }
            return stringBuilder.toString();
        }

        public Attribute member(Name name) {
            Pair<Symbol.MethodSymbol, Attribute> pair = this.getElemPair(name);
            return pair == null ? null : (Attribute)pair.snd;
        }

        private Pair<Symbol.MethodSymbol, Attribute> getElemPair(Name name) {
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                if (((Symbol.MethodSymbol)pair.fst).name != name) continue;
                return pair;
            }
            return null;
        }

        @Override
        public Compound getValue() {
            return this;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitAnnotation(this, p);
        }

        @Override
        public DeclaredType getAnnotationType() {
            return (DeclaredType)((Object)this.type);
        }

        public Map<Symbol.MethodSymbol, Attribute> getElementValues() {
            LinkedHashMap<Symbol.MethodSymbol, Attribute> linkedHashMap = new LinkedHashMap<Symbol.MethodSymbol, Attribute>();
            for (Pair<Symbol.MethodSymbol, Attribute> pair : this.values) {
                linkedHashMap.put((Symbol.MethodSymbol)pair.fst, (Attribute)pair.snd);
            }
            return linkedHashMap;
        }
    }

    public static class Class
    extends Attribute {
        public final Type classType;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitClass(this);
        }

        public Class(Types types, Type type) {
            super(Class.makeClassType(types, type));
            this.classType = type;
        }

        static Type makeClassType(Types types, Type type) {
            Type type2 = type.isPrimitive() ? types.boxedClass((Type)type).type : types.erasure(type);
            return new Type.ClassType(types.syms.classType.getEnclosingType(), List.of(type2), types.syms.classType.tsym);
        }

        @Override
        public String toString() {
            return this.classType + ".class";
        }

        @Override
        public Type getValue() {
            return this.classType;
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            return annotationValueVisitor.visitType(this.classType, p);
        }
    }

    public static class Constant
    extends Attribute {
        public final Object value;

        @Override
        public void accept(Visitor visitor) {
            visitor.visitConstant(this);
        }

        public Constant(Type type, Object object) {
            super(type);
            this.value = object;
        }

        @Override
        public String toString() {
            return Constants.format(this.value, this.type);
        }

        @Override
        public Object getValue() {
            return Constants.decode(this.value, this.type);
        }

        @Override
        public <R, P> R accept(AnnotationValueVisitor<R, P> annotationValueVisitor, P p) {
            if (this.value instanceof String) {
                return annotationValueVisitor.visitString((String)this.value, p);
            }
            if (this.value instanceof Integer) {
                int n = (Integer)this.value;
                switch (this.type.getTag()) {
                    case BOOLEAN: {
                        return annotationValueVisitor.visitBoolean(n != 0, p);
                    }
                    case CHAR: {
                        return annotationValueVisitor.visitChar((char)n, p);
                    }
                    case BYTE: {
                        return annotationValueVisitor.visitByte((byte)n, p);
                    }
                    case SHORT: {
                        return annotationValueVisitor.visitShort((short)n, p);
                    }
                    case INT: {
                        return annotationValueVisitor.visitInt(n, p);
                    }
                }
            }
            switch (this.type.getTag()) {
                case LONG: {
                    return annotationValueVisitor.visitLong((Long)this.value, p);
                }
                case FLOAT: {
                    return annotationValueVisitor.visitFloat(((Float)this.value).floatValue(), p);
                }
                case DOUBLE: {
                    return annotationValueVisitor.visitDouble((Double)this.value, p);
                }
            }
            throw new AssertionError((Object)("Bad annotation element value: " + this.value));
        }
    }
}

