/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.LongSubject;
import com.google.common.truth.Subject;
import java.util.OptionalLong;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class OptionalLongSubject
extends Subject<OptionalLongSubject, OptionalLong> {
    private final OptionalLong actual;

    OptionalLongSubject(FailureMetadata failureMetadata, @NullableDecl OptionalLong subject, @NullableDecl String typeDescription) {
        super(failureMetadata, (Object)subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact((String)"expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact((String)"expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact((String)"expected to be empty"), new Fact[]{Fact.fact((String)"but was present with value", (Object)this.actual.getAsLong())});
        }
    }

    public void hasValue(long expected) {
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact((String)"expected to have value", (Object)expected), new Fact[]{Fact.simpleFact((String)"but was absent")});
        } else {
            this.checkNoNeedToDisplayBothValues("getAsLong()", new Object[0]).that(Long.valueOf(this.actual.getAsLong())).isEqualTo((Object)expected);
        }
    }

    public LongSubject hasValueThat() {
        if (this.actual == null || !this.actual.isPresent()) {
            this.isPresent();
            return this.ignoreCheck().that(Long.valueOf(0L));
        }
        return this.check("getAsLong()", new Object[0]).that(Long.valueOf(this.actual.getAsLong()));
    }

    public static Subject.Factory<OptionalLongSubject, OptionalLong> optionalLongs() {
        return (metadata, subject) -> new OptionalLongSubject(metadata, (OptionalLong)subject, "optionalLong");
    }
}

