/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Operators {
    protected static final Context.Key<Operators> operatorsKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private Map<Name, List<UnaryOperatorHelper>> unaryOperators = new HashMap<Name, List<UnaryOperatorHelper>>(JCTree.Tag.getNumberOfOperators());
    private Map<Name, List<BinaryOperatorHelper>> binaryOperators = new HashMap<Name, List<BinaryOperatorHelper>>(JCTree.Tag.getNumberOfOperators());
    private Name[] opname = new Name[JCTree.Tag.getNumberOfOperators()];

    public static Operators instance(Context context) {
        Operators instance = context.get(operatorsKey);
        if (instance == null) {
            instance = new Operators(context);
        }
        return instance;
    }

    protected Operators(Context context) {
        context.put(operatorsKey, this);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.types = Types.instance(context);
        this.initOperatorNames();
        this.initUnaryOperators();
        this.initBinaryOperators();
    }

    Type unaryPromotion(Type t) {
        Type unboxed = this.types.unboxedTypeOrType(t);
        switch (unboxed.getTag()) {
            case BYTE: 
            case SHORT: 
            case CHAR: {
                return this.syms.intType;
            }
        }
        return unboxed;
    }

    Type binaryPromotion(Type t1, Type t2) {
        Type unboxedT1 = this.types.unboxedTypeOrType(t1);
        Type unboxedT2 = this.types.unboxedTypeOrType(t2);
        if (unboxedT1.isNumeric() && unboxedT2.isNumeric()) {
            if (unboxedT1.hasTag(TypeTag.DOUBLE) || unboxedT2.hasTag(TypeTag.DOUBLE)) {
                return this.syms.doubleType;
            }
            if (unboxedT1.hasTag(TypeTag.FLOAT) || unboxedT2.hasTag(TypeTag.FLOAT)) {
                return this.syms.floatType;
            }
            if (unboxedT1.hasTag(TypeTag.LONG) || unboxedT2.hasTag(TypeTag.LONG)) {
                return this.syms.longType;
            }
            return this.syms.intType;
        }
        if (this.types.isSameType(unboxedT1, unboxedT2)) {
            return unboxedT1;
        }
        return this.syms.objectType;
    }

    Symbol resolveUnary(JCDiagnostic.DiagnosticPosition pos, JCTree.Tag tag, Type op) {
        return this.resolve(tag, this.unaryOperators, unop -> unop.test(op), unop -> unop.resolve(op), () -> this.reportErrorIfNeeded(pos, tag, op));
    }

    Symbol resolveBinary(JCDiagnostic.DiagnosticPosition pos, JCTree.Tag tag, Type op1, Type op2) {
        return this.resolve(tag, this.binaryOperators, binop -> binop.test(op1, op2), binop -> binop.resolve(op1, op2), () -> this.reportErrorIfNeeded(pos, tag, op1, op2));
    }

    private <O> Symbol resolve(JCTree.Tag tag, Map<Name, List<O>> opMap, Predicate<O> opTestFunc, Function<O, Symbol> resolveFunc, Supplier<Symbol> noResultFunc) {
        return opMap.get(this.operatorName(tag)).stream().filter(opTestFunc).map(resolveFunc).findFirst().orElseGet(noResultFunc);
    }

    private Symbol makeOperator(Name name, List<OperatorType> formals, OperatorType res, int ... opcodes) {
        Type.MethodType opType = new Type.MethodType(formals.stream().map(o -> o.asType(this.syms)).collect(List.collector()), res.asType(this.syms), List.nil(), this.syms.methodClass);
        return new Symbol.OperatorSymbol(name, opType, this.mergeOpcodes(opcodes), (Symbol)this.syms.noSymbol);
    }

    private int mergeOpcodes(int ... opcodes) {
        int opcodesLen = opcodes.length;
        Assert.check(opcodesLen == 1 || opcodesLen == 2);
        return opcodesLen == 1 ? opcodes[0] : opcodes[0] << 9 | opcodes[1];
    }

    private Symbol reportErrorIfNeeded(JCDiagnostic.DiagnosticPosition pos, JCTree.Tag tag, Type ... args) {
        if (Stream.of(args).noneMatch(Type::isErroneous)) {
            Name opName = this.operatorName(tag);
            JCDiagnostic.Error opError = args.length == 1 ? CompilerProperties.Errors.OperatorCantBeApplied(opName, args[0]) : CompilerProperties.Errors.OperatorCantBeApplied1(opName, args[0], args[1]);
            this.log.error(pos, opError);
        }
        return this.syms.noSymbol;
    }

    public Name operatorName(JCTree.Tag tag) {
        return this.opname[tag.operatorIndex()];
    }

    private void initUnaryOperators() {
        this.initOperators(this.unaryOperators, new UnaryOperatorHelper[]{new UnaryNumericOperator(JCTree.Tag.POS).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 0).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 0).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 0).addUnaryOperator(OperatorType.INT, OperatorType.INT, 0), new UnaryNumericOperator(JCTree.Tag.NEG).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 119).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 118).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 117).addUnaryOperator(OperatorType.INT, OperatorType.INT, 116), new UnaryNumericOperator(JCTree.Tag.COMPL).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 131).addUnaryOperator(OperatorType.INT, OperatorType.INT, 130), new UnaryPrefixPostfixOperator(JCTree.Tag.POSTINC).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 99).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 98).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 97).addUnaryOperator(OperatorType.INT, OperatorType.INT, 96).addUnaryOperator(OperatorType.CHAR, OperatorType.CHAR, 96).addUnaryOperator(OperatorType.SHORT, OperatorType.SHORT, 96).addUnaryOperator(OperatorType.BYTE, OperatorType.BYTE, 96), new UnaryPrefixPostfixOperator(JCTree.Tag.POSTDEC).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 103).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 102).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 101).addUnaryOperator(OperatorType.INT, OperatorType.INT, 100).addUnaryOperator(OperatorType.CHAR, OperatorType.CHAR, 100).addUnaryOperator(OperatorType.SHORT, OperatorType.SHORT, 100).addUnaryOperator(OperatorType.BYTE, OperatorType.BYTE, 100), new UnaryBooleanOperator(JCTree.Tag.NOT).addUnaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, 257), new UnaryReferenceOperator(JCTree.Tag.NULLCHK).addUnaryOperator(OperatorType.OBJECT, OperatorType.OBJECT, 276)});
    }

    private void initBinaryOperators() {
        this.initOperators(this.binaryOperators, new BinaryOperatorHelper[]{new BinaryStringOperator(JCTree.Tag.PLUS).addBinaryOperator(OperatorType.STRING, OperatorType.OBJECT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.OBJECT, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.INT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.LONG, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.FLOAT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.DOUBLE, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.BOOLEAN, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.BOT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.INT, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.LONG, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.FLOAT, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.DOUBLE, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.BOT, OperatorType.STRING, OperatorType.STRING, 256), new BinaryNumericOperator(JCTree.Tag.PLUS).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 99).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 98).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 97).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 96), new BinaryNumericOperator(JCTree.Tag.MINUS).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 103).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 102).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 101).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 100), new BinaryNumericOperator(JCTree.Tag.MUL).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 107).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 106).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 105).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 104), new BinaryNumericOperator(JCTree.Tag.DIV).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 111).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 110).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 109).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 108), new BinaryNumericOperator(JCTree.Tag.MOD).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 115).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 114).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 113).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 112), new BinaryBooleanOperator(JCTree.Tag.BITAND).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 126), new BinaryNumericOperator(JCTree.Tag.BITAND).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 127).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 126), new BinaryBooleanOperator(JCTree.Tag.BITOR).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 128), new BinaryNumericOperator(JCTree.Tag.BITOR).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 129).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 128), new BinaryBooleanOperator(JCTree.Tag.BITXOR).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 130), new BinaryNumericOperator(JCTree.Tag.BITXOR).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 131).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 130), new BinaryShiftOperator(JCTree.Tag.SL).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 120).addBinaryOperator(OperatorType.INT, OperatorType.LONG, OperatorType.INT, 270).addBinaryOperator(OperatorType.LONG, OperatorType.INT, OperatorType.LONG, 121).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 271), new BinaryShiftOperator(JCTree.Tag.SR).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 122).addBinaryOperator(OperatorType.INT, OperatorType.LONG, OperatorType.INT, 272).addBinaryOperator(OperatorType.LONG, OperatorType.INT, OperatorType.LONG, 123).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 273), new BinaryShiftOperator(JCTree.Tag.USR).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 124).addBinaryOperator(OperatorType.INT, OperatorType.LONG, OperatorType.INT, 274).addBinaryOperator(OperatorType.LONG, OperatorType.INT, OperatorType.LONG, 125).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 275), new BinaryNumericOperator(JCTree.Tag.LT).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 152, 155).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 150, 155).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 155).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 161), new BinaryNumericOperator(JCTree.Tag.GT).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 157).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 157).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 157).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 163), new BinaryNumericOperator(JCTree.Tag.LE).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 152, 158).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 150, 158).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 158).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 164), new BinaryNumericOperator(JCTree.Tag.GE).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 156).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 156).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 156).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 162), new BinaryEqualityOperator(JCTree.Tag.EQ).addBinaryOperator(OperatorType.OBJECT, OperatorType.OBJECT, OperatorType.BOOLEAN, 165).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 159).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 153).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 153).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 153).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 159), new BinaryEqualityOperator(JCTree.Tag.NE).addBinaryOperator(OperatorType.OBJECT, OperatorType.OBJECT, OperatorType.BOOLEAN, 166).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 160).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 154).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 154).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 154).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 160), new BinaryBooleanOperator(JCTree.Tag.AND).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 258), new BinaryBooleanOperator(JCTree.Tag.OR).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 259)});
    }

    @SafeVarargs
    private final <O extends OperatorHelper> void initOperators(Map<Name, List<O>> opsMap, O ... ops) {
        for (O o : ops) {
            Name opName = ((OperatorHelper)o).name;
            List<O> helpers = opsMap.getOrDefault(opName, List.nil());
            opsMap.put(opName, helpers.prepend(o));
        }
    }

    private void initOperatorNames() {
        this.setOperatorName(JCTree.Tag.POS, "+");
        this.setOperatorName(JCTree.Tag.NEG, "-");
        this.setOperatorName(JCTree.Tag.NOT, "!");
        this.setOperatorName(JCTree.Tag.COMPL, "~");
        this.setOperatorName(JCTree.Tag.PREINC, "++");
        this.setOperatorName(JCTree.Tag.PREDEC, "--");
        this.setOperatorName(JCTree.Tag.POSTINC, "++");
        this.setOperatorName(JCTree.Tag.POSTDEC, "--");
        this.setOperatorName(JCTree.Tag.NULLCHK, "<*nullchk*>");
        this.setOperatorName(JCTree.Tag.OR, "||");
        this.setOperatorName(JCTree.Tag.AND, "&&");
        this.setOperatorName(JCTree.Tag.EQ, "==");
        this.setOperatorName(JCTree.Tag.NE, "!=");
        this.setOperatorName(JCTree.Tag.LT, "<");
        this.setOperatorName(JCTree.Tag.GT, ">");
        this.setOperatorName(JCTree.Tag.LE, "<=");
        this.setOperatorName(JCTree.Tag.GE, ">=");
        this.setOperatorName(JCTree.Tag.BITOR, "|");
        this.setOperatorName(JCTree.Tag.BITXOR, "^");
        this.setOperatorName(JCTree.Tag.BITAND, "&");
        this.setOperatorName(JCTree.Tag.SL, "<<");
        this.setOperatorName(JCTree.Tag.SR, ">>");
        this.setOperatorName(JCTree.Tag.USR, ">>>");
        this.setOperatorName(JCTree.Tag.PLUS, "+");
        this.setOperatorName(JCTree.Tag.MINUS, this.names.hyphen);
        this.setOperatorName(JCTree.Tag.MUL, this.names.asterisk);
        this.setOperatorName(JCTree.Tag.DIV, this.names.slash);
        this.setOperatorName(JCTree.Tag.MOD, "%");
    }

    private void setOperatorName(JCTree.Tag tag, String name) {
        this.setOperatorName(tag, this.names.fromString(name));
    }

    private void setOperatorName(JCTree.Tag tag, Name name) {
        this.opname[tag.operatorIndex()] = name;
    }

    class BinaryEqualityOperator
    extends BinaryOperatorHelper {
        BinaryEqualityOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type arg1, Type arg2) {
            return this.getKind(arg1, arg2) != ComparisonKind.INVALID;
        }

        @Override
        public Symbol resolve(Type t1, Type t2) {
            ComparisonKind kind = this.getKind(t1, t2);
            Type t = kind == ComparisonKind.NUMERIC_OR_BOOLEAN ? Operators.this.binaryPromotion(t1, t2) : ((Operators)Operators.this).syms.objectType;
            return this.doLookup(t, t);
        }

        private ComparisonKind getKind(Type arg1, Type arg2) {
            boolean arg1Primitive = arg1.isPrimitive();
            boolean arg2Primitive = arg2.isPrimitive();
            if (arg1Primitive && arg2Primitive) {
                return ComparisonKind.NUMERIC_OR_BOOLEAN;
            }
            if (arg1Primitive) {
                return Operators.this.unaryPromotion(arg2).isPrimitive() ? ComparisonKind.NUMERIC_OR_BOOLEAN : ComparisonKind.INVALID;
            }
            if (arg2Primitive) {
                return Operators.this.unaryPromotion(arg1).isPrimitive() ? ComparisonKind.NUMERIC_OR_BOOLEAN : ComparisonKind.INVALID;
            }
            return arg1.isNullOrReference() && arg2.isNullOrReference() ? ComparisonKind.REFERENCE : ComparisonKind.INVALID;
        }
    }

    static enum ComparisonKind {
        NUMERIC_OR_BOOLEAN,
        REFERENCE,
        INVALID;

    }

    class BinaryShiftOperator
    extends BinaryOperatorHelper {
        BinaryShiftOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol resolve(Type arg1, Type arg2) {
            return this.doLookup(Operators.this.unaryPromotion(arg1), Operators.this.unaryPromotion(arg2));
        }

        @Override
        public boolean test(Type arg1, Type arg2) {
            TypeTag op1 = Operators.this.unaryPromotion(arg1).getTag();
            TypeTag op2 = Operators.this.unaryPromotion(arg2).getTag();
            return !(op1 != TypeTag.LONG && op1 != TypeTag.INT || op2 != TypeTag.LONG && op2 != TypeTag.INT);
        }
    }

    class BinaryStringOperator
    extends BinaryOperatorHelper {
        BinaryStringOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol resolve(Type arg1, Type arg2) {
            return this.doLookup(this.stringPromotion(arg1), this.stringPromotion(arg2));
        }

        @Override
        public boolean test(Type arg1, Type arg2) {
            return Operators.this.types.isSameType(arg1, ((Operators)Operators.this).syms.stringType) || Operators.this.types.isSameType(arg2, ((Operators)Operators.this).syms.stringType);
        }

        private Type stringPromotion(Type t) {
            if (t.isPrimitive()) {
                return Operators.this.unaryPromotion(t);
            }
            if (t.hasTag(TypeTag.BOT) || Operators.this.types.isSameType(t, ((Operators)Operators.this).syms.stringType)) {
                return t;
            }
            if (t.hasTag(TypeTag.TYPEVAR)) {
                return this.stringPromotion(t.getUpperBound());
            }
            return ((Operators)Operators.this).syms.objectType;
        }
    }

    class BinaryBooleanOperator
    extends BinaryOperatorHelper {
        BinaryBooleanOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol resolve(Type arg1, Type arg2) {
            return this.doLookup(((Operators)Operators.this).syms.booleanType, ((Operators)Operators.this).syms.booleanType);
        }

        @Override
        public boolean test(Type arg1, Type arg2) {
            return Operators.this.types.unboxedTypeOrType(arg1).hasTag(TypeTag.BOOLEAN) && Operators.this.types.unboxedTypeOrType(arg2).hasTag(TypeTag.BOOLEAN);
        }
    }

    class BinaryNumericOperator
    extends BinaryOperatorHelper {
        BinaryNumericOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol resolve(Type arg1, Type arg2) {
            Type t = Operators.this.binaryPromotion(arg1, arg2);
            return this.doLookup(t, t);
        }

        @Override
        public boolean test(Type arg1, Type arg2) {
            return Operators.this.unaryPromotion(arg1).isNumeric() && Operators.this.unaryPromotion(arg2).isNumeric();
        }
    }

    class UnaryPrefixPostfixOperator
    extends UnaryNumericOperator {
        UnaryPrefixPostfixOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol resolve(Type arg) {
            return this.doLookup(Operators.this.types.unboxedTypeOrType(arg));
        }
    }

    class UnaryBooleanOperator
    extends UnaryOperatorHelper {
        UnaryBooleanOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type type) {
            return Operators.this.types.unboxedTypeOrType(type).hasTag(TypeTag.BOOLEAN);
        }

        @Override
        public Symbol resolve(Type arg) {
            return this.doLookup(((Operators)Operators.this).syms.booleanType);
        }
    }

    class UnaryNumericOperator
    extends UnaryOperatorHelper {
        UnaryNumericOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type type) {
            return Operators.this.unaryPromotion(type).isNumeric();
        }

        @Override
        public Symbol resolve(Type arg) {
            return this.doLookup(Operators.this.unaryPromotion(arg));
        }
    }

    class UnaryReferenceOperator
    extends UnaryOperatorHelper {
        UnaryReferenceOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type type) {
            return type.isNullOrReference();
        }

        @Override
        public Symbol resolve(Type arg) {
            return this.doLookup(((Operators)Operators.this).syms.objectType);
        }
    }

    abstract class BinaryOperatorHelper
    extends OperatorHelper
    implements BiPredicate<Type, Type> {
        BinaryOperatorHelper(JCTree.Tag tag) {
            super(tag);
        }

        final Symbol doLookup(Type t1, Type t2) {
            return this.doLookup(op -> this.isBinaryOperatorApplicable((Symbol.OperatorSymbol)op, t1, t2));
        }

        boolean isBinaryOperatorApplicable(Symbol.OperatorSymbol op, Type t1, Type t2) {
            List<Type> formals = op.type.getParameterTypes();
            return Operators.this.types.isSameType((Type)formals.head, t1) && Operators.this.types.isSameType((Type)formals.tail.head, t2);
        }

        final BinaryOperatorHelper addBinaryOperator(OperatorType arg1, OperatorType arg2, OperatorType res, int ... opcode) {
            this.operatorSuppliers = this.operatorSuppliers.prepend(() -> Operators.this.makeOperator(this.name, List.of(arg1, arg2), res, opcode));
            return this;
        }

        abstract Symbol resolve(Type var1, Type var2);
    }

    abstract class UnaryOperatorHelper
    extends OperatorHelper
    implements Predicate<Type> {
        UnaryOperatorHelper(JCTree.Tag tag) {
            super(tag);
        }

        final Symbol doLookup(Type t) {
            return this.doLookup((Symbol op) -> this.isUnaryOperatorApplicable((Symbol.OperatorSymbol)op, t));
        }

        boolean isUnaryOperatorApplicable(Symbol.OperatorSymbol op, Type t) {
            return Operators.this.types.isSameType((Type)op.type.getParameterTypes().head, t);
        }

        final UnaryOperatorHelper addUnaryOperator(OperatorType arg, OperatorType res, int ... opcode) {
            this.operatorSuppliers = this.operatorSuppliers.prepend(() -> Operators.this.makeOperator(this.name, List.of(arg), res, opcode));
            return this;
        }

        abstract Symbol resolve(Type var1);
    }

    abstract class OperatorHelper {
        final Name name;
        Optional<Symbol[]> alternatives = Optional.empty();
        List<Supplier<Symbol>> operatorSuppliers = List.nil();

        OperatorHelper(JCTree.Tag tag) {
            this.name = Operators.this.operatorName(tag);
        }

        final Symbol doLookup(Predicate<Symbol> applicabilityTest) {
            return Stream.of(this.alternatives.orElseGet(this::initOperators)).filter(applicabilityTest).findFirst().orElse(((Operators)Operators.this).syms.noSymbol);
        }

        private Symbol[] initOperators() {
            Symbol[] operators = (Symbol[])this.operatorSuppliers.stream().map(op -> (Symbol)op.get()).toArray(Symbol[]::new);
            this.alternatives = Optional.of(operators);
            this.operatorSuppliers = null;
            return operators;
        }
    }

    static enum OperatorType {
        BYTE(syms -> syms.byteType),
        SHORT(syms -> syms.shortType),
        INT(syms -> syms.intType),
        LONG(syms -> syms.longType),
        FLOAT(syms -> syms.floatType),
        DOUBLE(syms -> syms.doubleType),
        CHAR(syms -> syms.charType),
        BOOLEAN(syms -> syms.booleanType),
        OBJECT(syms -> syms.objectType),
        STRING(syms -> syms.stringType),
        BOT(syms -> syms.botType);

        final Function<Symtab, Type> asTypeFunc;

        private OperatorType(Function<Symtab, Type> asTypeFunc) {
            this.asTypeFunc = asTypeFunc;
        }

        Type asType(Symtab syms) {
            return this.asTypeFunc.apply(syms);
        }
    }
}

