/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.ArrayAccess;
import lombok.ast.BinaryExpression;
import lombok.ast.BinaryOperator;
import lombok.ast.Cast;
import lombok.ast.ConstructorInvocation;
import lombok.ast.Expression;
import lombok.ast.InlineIfExpression;
import lombok.ast.InstanceOf;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;
import lombok.ast.UnaryExpression;

class BinaryExpressionTemplate {
    Expression left1;
    Expression right3;
    BinaryOperator operator2;

    BinaryExpressionTemplate() {
    }

    static String getDescription(BinaryExpression self) {
        try {
            return self.astOperator().getSymbol();
        }
        catch (Exception e) {
            return self.rawOperator();
        }
    }

    static String generateOperator(BinaryOperator op) {
        return op.getSymbol();
    }

    static BinaryOperator parseOperator(String op) {
        if (op == null) {
            throw new IllegalArgumentException("missing operator");
        }
        BinaryOperator result = BinaryOperator.fromSymbol(op.trim());
        if (result == null) {
            throw new IllegalArgumentException("unknown binary operator: " + op.trim());
        }
        return result;
    }

    static boolean needsParentheses(Expression self) {
        try {
            return BinaryExpressionTemplate.needsParentheses(self, ((BinaryExpression)self).astOperator().pLevel());
        }
        catch (Throwable ignore) {
            return true;
        }
    }

    static boolean needsParentheses(Node self, int pLevel) {
        Node parent = self.getParent();
        if (parent instanceof InlineIfExpression) {
            if (!(self instanceof InlineIfExpression)) {
                return pLevel >= BinaryOperator.ASSIGN.pLevel();
            }
            return ((InlineIfExpression)parent).rawIfFalse() != self;
        }
        if (parent instanceof UnaryExpression || parent instanceof Cast || parent instanceof ConstructorInvocation) {
            if (parent instanceof ConstructorInvocation && ((ConstructorInvocation)parent).rawQualifier() != self) {
                return false;
            }
            boolean otherPLevel = true;
            if (1 > pLevel) {
                return false;
            }
            if (1 < pLevel) {
                return true;
            }
            boolean otherIsPostfix = false;
            boolean selfIsPostfix = false;
            try {
                otherIsPostfix = parent instanceof ConstructorInvocation ? true : ((UnaryExpression)parent).astOperator().isPostfix();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            try {
                selfIsPostfix = self instanceof ConstructorInvocation ? true : ((UnaryExpression)self).astOperator().isPostfix();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            return !selfIsPostfix && otherIsPostfix;
        }
        if (parent instanceof ConstructorInvocation) {
            return self == ((ConstructorInvocation)parent).rawQualifier();
        }
        if (parent instanceof MethodInvocation) {
            return self == ((MethodInvocation)parent).rawOperand();
        }
        if (parent instanceof ArrayAccess) {
            return self == ((ArrayAccess)parent).rawOperand();
        }
        if (parent instanceof Select) {
            return self == ((Select)parent).rawOperand();
        }
        if (parent instanceof InstanceOf) {
            return pLevel > BinaryOperator.LESS.pLevel();
        }
        if (parent instanceof BinaryExpression) {
            int otherPLevel;
            BinaryExpression be = (BinaryExpression)parent;
            try {
                otherPLevel = be.astOperator().pLevel();
            }
            catch (Throwable ignore) {
                return true;
            }
            if (otherPLevel > pLevel) {
                return false;
            }
            if (otherPLevel < pLevel) {
                return true;
            }
            if (be.rawLeft() == self) {
                return pLevel == BinaryOperator.ASSIGN.pLevel();
            }
            if (be.rawRight() == self) {
                return pLevel != BinaryOperator.ASSIGN.pLevel();
            }
            return true;
        }
        return false;
    }
}

