/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.DoNotCall;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(name="DoNotCall", category=BugPattern.Category.JDK, summary="This method should not be called.", severity=BugPattern.SeverityLevel.ERROR)
public class DoNotCallChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree, DoNotCall.class, (VisitorState)state)) {
            if (symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return Description.NO_MATCH;
            }
            if (symbol.getModifiers().contains((Object)Modifier.FINAL)) {
                return Description.NO_MATCH;
            }
            if (symbol.owner.enclClass().getModifiers().contains((Object)Modifier.FINAL)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).setMessage("Methods annotated with @DoNotCall should be final.").addFix((Fix)SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).stream().filter(s -> ASTHelpers.hasAnnotation((Symbol)s, DoNotCall.class, (VisitorState)state)).findAny().map(s -> {
            String message = String.format("Method overrides %s in %s which is annotated @DoNotCall, it should also be annotated.", s.getSimpleName(), s.owner.getSimpleName());
            return this.buildDescription(tree).setMessage(message).addFix((Fix)SuggestedFix.builder().addImport(DoNotCall.class.getName()).prefixWith((Tree)tree, "@DoNotCall ").build()).build();
        }).orElse(Description.NO_MATCH);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        DoNotCall doNotCall = (DoNotCall)ASTHelpers.getAnnotation((Tree)tree, DoNotCall.class);
        if (doNotCall == null) {
            return Description.NO_MATCH;
        }
        StringBuilder message = new StringBuilder("This method should not be called");
        if (doNotCall.value().isEmpty()) {
            message.append(", see its documentation for details.");
        } else {
            message.append(": ").append(doNotCall.value());
        }
        return this.buildDescription(tree).setMessage(message.toString()).build();
    }
}

