/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.CharMatcher;
import com.google.common.base.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.ImmutableValueGraph;
import com.google.common.hash.HashCode;
import com.google.common.io.BaseEncoding;
import com.google.common.net.MediaType;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnnotationInfo;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.Annotation;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

final class WellKnownMutability {
    static final ImmutableMap<String, ImmutableAnnotationInfo> KNOWN_IMMUTABLE = WellKnownMutability.getBootstrapClasses();
    static final ImmutableSet<String> KNOWN_UNSAFE = WellKnownMutability.getKnownUnsafeClasses();
    private static final Supplier<Type> MESSAGE_TYPE = Suppliers.typeFromString((String)"com.google.protobuf.MessageLite");
    private static final Supplier<Type> MUTABLE_MESSAGE_TYPE = Suppliers.typeFromString((String)"com.google.protobuf.MutableMessageLite");
    private static final Supplier<Type> PROTOCOL_MESSAGE_TYPE = Suppliers.typeFromString((String)"com.google.io.protocol.ProtocolMessage");

    WellKnownMutability() {
    }

    private static ImmutableMap<String, ImmutableAnnotationInfo> getBootstrapClasses() {
        return new Builder().addAll(Primitives.allPrimitiveTypes()).addAll(Primitives.allWrapperTypes()).add("com.google.protobuf.ByteString", new String[0]).add("com.google.protobuf.Descriptors$Descriptor", new String[0]).add("com.google.protobuf.Descriptors$EnumDescriptor", new String[0]).add("com.google.protobuf.Descriptors$EnumValueDescriptor", new String[0]).add("com.google.protobuf.Descriptors$FieldDescriptor", new String[0]).add("com.google.protobuf.Descriptors$FileDescriptor", new String[0]).add("com.google.protobuf.Descriptors$ServiceDescriptor", new String[0]).add("com.google.protobuf.Extension", new String[0]).add("com.google.protobuf.ExtensionRegistry$ExtensionInfo", new String[0]).add("com.google.re2j.Pattern", new String[0]).add(CharMatcher.class, new String[0]).add(Converter.class, new String[0]).add(Joiner.class, new String[0]).add(Optional.class, "T").add(Splitter.class, new String[0]).add(ImmutableBiMap.class, "K", "V").add(ImmutableCollection.class, "E").add(ImmutableList.class, "E").add(ImmutableListMultimap.class, "K", "V").add(ImmutableMap.class, "K", "V").add(ImmutableMultimap.class, "K", "V").add(ImmutableMultiset.class, "E").add(ImmutableRangeMap.class, "K", "V").add(ImmutableRangeSet.class, "C").add(ImmutableSet.class, "E").add(ImmutableSetMultimap.class, "K", "V").add(ImmutableSortedMap.class, "K", "V").add(ImmutableSortedMultiset.class, "E").add(ImmutableSortedSet.class, "E").add(ImmutableTable.class, "R", "C", "V").add(Range.class, "C").add(ImmutableGraph.class, "N").add(ImmutableNetwork.class, "N", "E").add(ImmutableValueGraph.class, "N", "V").add(HashCode.class, new String[0]).add(BaseEncoding.class, new String[0]).add(MediaType.class, new String[0]).add(UnsignedLong.class, new String[0]).add(Class.class, new String[0]).add(String.class, new String[0]).add(Annotation.class, new String[0]).add(BigDecimal.class, new String[0]).add(BigInteger.class, new String[0]).add(InetAddress.class, new String[0]).add(Locale.class, new String[0]).add(Pattern.class, new String[0]).add("android.net.Uri", new String[0]).add("java.util.Optional", "T").add("java.time.Duration", new String[0]).add("java.time.Instant", new String[0]).add("java.time.LocalDate", new String[0]).add("java.time.LocalDateTime", new String[0]).add("java.time.LocalTime", new String[0]).add("java.time.MonthDay", new String[0]).add("java.time.OffsetDateTime", new String[0]).add("java.time.OffsetTime", new String[0]).add("java.time.Period", new String[0]).add("java.time.Year", new String[0]).add("java.time.YearMonth", new String[0]).add("java.time.ZoneId", new String[0]).add("java.time.ZoneOffset", new String[0]).add("java.time.ZonedDateTime", new String[0]).add("java.time.chrono.AbstractChronology", new String[0]).add("java.time.chrono.ChronoLocalDate", new String[0]).add("java.time.chrono.ChronoLocalDateTime", "D").add("java.time.chrono.ChronoPeriod", new String[0]).add("java.time.chrono.ChronoZonedDateTime", "D").add("java.time.chrono.Chronology", new String[0]).add("java.time.chrono.Era", new String[0]).add("java.time.chrono.HijrahChronology", new String[0]).add("java.time.chrono.HijrahDate", new String[0]).add("java.time.chrono.IsoChronology", new String[0]).add("java.time.chrono.JapaneseChronology", new String[0]).add("java.time.chrono.JapaneseDate", new String[0]).add("java.time.chrono.JapaneseEra", new String[0]).add("java.time.chrono.MinguoChronology", new String[0]).add("java.time.chrono.MinguoDate", new String[0]).add("java.time.chrono.ThaiBuddhistChronology", new String[0]).add("java.time.chrono.ThaiBuddhistDate", new String[0]).add("java.time.format.DateTimeFormatter", new String[0]).add("java.time.format.DecimalStyle", new String[0]).add("java.time.temporal.TemporalField", new String[0]).add("java.time.temporal.TemporalUnit", new String[0]).add("java.time.temporal.ValueRange", new String[0]).add("java.time.temporal.WeekFields", new String[0]).add("java.time.zone.ZoneOffsetTransition", new String[0]).add("java.time.zone.ZoneOffsetTransitionRule", new String[0]).add("java.time.zone.ZoneRules", new String[0]).add("java.time.zone.ZoneRulesProvider", new String[0]).add("org.joda.time.DateTime", new String[0]).add("org.joda.time.DateTimeZone", new String[0]).add("org.joda.time.Duration", new String[0]).add("org.joda.time.Instant", new String[0]).add("org.joda.time.LocalDate", new String[0]).add("org.joda.time.LocalDateTime", new String[0]).add("org.joda.time.Period", new String[0]).add("org.joda.time.format.DateTimeFormatter", new String[0]).build();
    }

    private static ImmutableSet<String> getKnownUnsafeClasses() {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (Class clazz : ImmutableSet.of(Iterable.class, Object.class, ArrayList.class, Collection.class, List.class, Map.class, (Object[])new Class[]{Set.class, EnumSet.class, EnumMap.class})) {
            result.add((Object)clazz.getName());
        }
        return result.build();
    }

    private static boolean isAssignableTo(Type type, Supplier<Type> supplier, VisitorState state) {
        Type to = (Type)supplier.get(state);
        if (to == null) {
            return false;
        }
        return state.getTypes().isAssignable(type, to);
    }

    static boolean isProto2MessageClass(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        return WellKnownMutability.isAssignableTo(type, MESSAGE_TYPE, state) && !WellKnownMutability.isAssignableTo(type, PROTOCOL_MESSAGE_TYPE, state);
    }

    static boolean isProto2MutableMessageClass(VisitorState state, Type type) {
        Preconditions.checkNotNull((Object)type);
        return WellKnownMutability.isAssignableTo(type, MUTABLE_MESSAGE_TYPE, state) && !WellKnownMutability.isAssignableTo(type, PROTOCOL_MESSAGE_TYPE, state);
    }

    static boolean isAnnotation(VisitorState state, Type type) {
        return WellKnownMutability.isAssignableTo(type, (Supplier<Type>)Suppliers.ANNOTATION_TYPE, state);
    }

    static class Builder {
        final ImmutableMap.Builder<String, ImmutableAnnotationInfo> mapBuilder = ImmutableMap.builder();

        Builder() {
        }

        public Builder addAll(Set<Class<?>> clazzs) {
            for (Class<?> clazz : clazzs) {
                this.add(clazz, new String[0]);
            }
            return this;
        }

        public Builder add(Class<?> clazz, String ... containerOf) {
            ImmutableSet containerTyParams = ImmutableSet.copyOf((Object[])containerOf);
            HashSet<String> actualTyParams = new HashSet<String>();
            for (TypeVariable<Class<?>> x : clazz.getTypeParameters()) {
                actualTyParams.add(x.getName());
            }
            Sets.SetView difference = Sets.difference((Set)containerTyParams, actualTyParams);
            if (!difference.isEmpty()) {
                throw new AssertionError((Object)String.format("For %s, please update the type parameter(s) from %s to %s", clazz, difference, actualTyParams));
            }
            this.mapBuilder.put((Object)clazz.getName(), (Object)ImmutableAnnotationInfo.create(clazz.getName(), (Iterable<String>)ImmutableList.copyOf((Object[])containerOf)));
            return this;
        }

        public Builder add(String className, String ... containerOf) {
            this.mapBuilder.put((Object)className, (Object)ImmutableAnnotationInfo.create(className, (Iterable<String>)ImmutableList.copyOf((Object[])containerOf)));
            return this;
        }

        public ImmutableMap<String, ImmutableAnnotationInfo> build() {
            return this.mapBuilder.build();
        }
    }
}

