/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.refaster.AutoValue_UPlaceholderStatement;
import com.google.errorprone.refaster.AutoValue_UPlaceholderStatement_ConsumptionState;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.ControlFlowVisitor;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.PlaceholderMethod;
import com.google.errorprone.refaster.PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.PlaceholderVerificationVisitor;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import java.util.Collection;

abstract class UPlaceholderStatement
implements UStatement {
    UPlaceholderStatement() {
    }

    static UPlaceholderStatement create(PlaceholderMethod placeholder, Iterable<? extends UExpression> arguments, ControlFlowVisitor.Result implementationFlow) {
        ImmutableList placeholderParams = placeholder.parameters().asList();
        ImmutableList argumentsList = ImmutableList.copyOf(arguments);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < placeholderParams.size(); ++i) {
            builder.put(placeholderParams.get(i), argumentsList.get(i));
        }
        return new AutoValue_UPlaceholderStatement(placeholder, (ImmutableMap<UVariableDecl, UExpression>)builder.build(), implementationFlow);
    }

    abstract PlaceholderMethod placeholder();

    abstract ImmutableMap<UVariableDecl, UExpression> arguments();

    abstract ControlFlowVisitor.Result implementationFlow();

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OTHER;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitOther(this, data);
    }

    public Choice<UStatement.UnifierWithUnconsumedStatements> apply(final UStatement.UnifierWithUnconsumedStatements initState) {
        final PlaceholderUnificationVisitor visitor = PlaceholderUnificationVisitor.create(TreeMaker.instance(initState.unifier().getContext()), this.arguments());
        PlaceholderVerificationVisitor verification = new PlaceholderVerificationVisitor(Collections2.transform(this.placeholder().requiredParameters(), (Function)Functions.forMap(this.arguments())), (Collection<? extends UExpression>)this.arguments().values());
        Choice<Object> realOptions = Choice.none();
        Choice<PlaceholderUnificationVisitor.State<ConsumptionState>> choiceToHere = Choice.of(PlaceholderUnificationVisitor.State.create(List.nil(), initState.unifier(), ConsumptionState.empty()));
        if (verification.allRequiredMatched()) {
            realOptions = choiceToHere.or(realOptions);
        }
        for (final StatementTree statementTree : initState.unconsumedStatements()) {
            if (!verification.scan((Tree)statementTree, initState.unifier()).booleanValue()) break;
            choiceToHere = choiceToHere.thenChoose(new Function<PlaceholderUnificationVisitor.State<ConsumptionState>, Choice<PlaceholderUnificationVisitor.State<ConsumptionState>>>(){

                public Choice<PlaceholderUnificationVisitor.State<ConsumptionState>> apply(final PlaceholderUnificationVisitor.State<ConsumptionState> consumptionState) {
                    return visitor.unifyStatement(statementTree, consumptionState).transform(new Function<PlaceholderUnificationVisitor.State<? extends JCTree.JCStatement>, PlaceholderUnificationVisitor.State<ConsumptionState>>(){

                        public PlaceholderUnificationVisitor.State<ConsumptionState> apply(PlaceholderUnificationVisitor.State<? extends JCTree.JCStatement> stmtState) {
                            return stmtState.withResult(((ConsumptionState)consumptionState.result()).consume(stmtState.result()));
                        }
                    });
                }
            });
            if (!verification.allRequiredMatched()) continue;
            realOptions = choiceToHere.or(realOptions);
        }
        return realOptions.thenOption(new Function<PlaceholderUnificationVisitor.State<ConsumptionState>, Optional<UStatement.UnifierWithUnconsumedStatements>>(){

            public Optional<UStatement.UnifierWithUnconsumedStatements> apply(PlaceholderUnificationVisitor.State<ConsumptionState> consumptionState) {
                if (ImmutableSet.copyOf(consumptionState.seenParameters()).containsAll(UPlaceholderStatement.this.placeholder().requiredParameters())) {
                    Unifier resultUnifier = consumptionState.unifier().fork();
                    int nConsumedStatements = consumptionState.result().consumedStatements();
                    java.util.List<? extends StatementTree> remainingStatements = initState.unconsumedStatements().subList(nConsumedStatements, initState.unconsumedStatements().size());
                    UStatement.UnifierWithUnconsumedStatements result = UStatement.UnifierWithUnconsumedStatements.create(resultUnifier, remainingStatements);
                    List<JCTree.JCStatement> impl = consumptionState.result().placeholderImplInReverseOrder().reverse();
                    ControlFlowVisitor.Result implFlow = ControlFlowVisitor.INSTANCE.visitStatements(impl);
                    if (implFlow == UPlaceholderStatement.this.implementationFlow()) {
                        List<JCTree.JCStatement> prevBinding = resultUnifier.getBinding(UPlaceholderStatement.this.placeholder().blockKey());
                        if (prevBinding != null && prevBinding.toString().equals(impl.toString())) {
                            return Optional.of((Object)result);
                        }
                        if (prevBinding == null) {
                            resultUnifier.putBinding(UPlaceholderStatement.this.placeholder().blockKey(), impl);
                            return Optional.of((Object)result);
                        }
                    }
                }
                return Optional.absent();
            }
        });
    }

    @Override
    public List<JCTree.JCStatement> inlineStatements(final Inliner inliner) throws CouldNotResolveImportException {
        try {
            Optional binding = inliner.getOptionalBinding(this.placeholder().blockKey());
            Optional<JCTree.JCExpression> exprBinding = inliner.getOptionalBinding(this.placeholder().exprKey());
            binding = binding.or(exprBinding.transform((Function)new Function<JCTree.JCExpression, List<JCTree.JCStatement>>(){

                public List<JCTree.JCStatement> apply(JCTree.JCExpression expr) {
                    switch (UPlaceholderStatement.this.implementationFlow()) {
                        case NEVER_EXITS: {
                            return List.of(inliner.maker().Exec(expr));
                        }
                        case ALWAYS_RETURNS: {
                            return List.of(inliner.maker().Return(expr));
                        }
                    }
                    throw new AssertionError();
                }
            }));
            return UPlaceholderExpression.copier(this.arguments(), inliner).copy((List)binding.get(), inliner);
        }
        catch (UPlaceholderExpression.UncheckedCouldNotResolveImportException e) {
            throw e.getCause();
        }
    }

    static abstract class ConsumptionState {
        ConsumptionState() {
        }

        static ConsumptionState empty() {
            return new AutoValue_UPlaceholderStatement_ConsumptionState(0, List.nil());
        }

        abstract int consumedStatements();

        abstract List<JCTree.JCStatement> placeholderImplInReverseOrder();

        ConsumptionState consume(JCTree.JCStatement impl) {
            return new AutoValue_UPlaceholderStatement_ConsumptionState(this.consumedStatements() + 1, this.placeholderImplInReverseOrder().prepend(impl));
        }
    }
}

