/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.errorprone.dataflow.AutoValue_DataFlow_AnalysisParams;
import com.google.errorprone.dataflow.AutoValue_DataFlow_CfgParams;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import org.checkerframework.dataflow.analysis.AbstractValue;
import org.checkerframework.dataflow.analysis.Analysis;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.analysis.TransferFunction;
import org.checkerframework.dataflow.cfg.CFGBuilder;
import org.checkerframework.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.dataflow.cfg.UnderlyingAST;

public final class DataFlow {
    private static final LoadingCache<AnalysisParams, Analysis<?, ?, ?>> analysisCache = CacheBuilder.newBuilder().build(new CacheLoader<AnalysisParams, Analysis<?, ?, ?>>(){

        public Analysis<?, ?, ?> load(AnalysisParams key) {
            ProcessingEnvironment env = key.environment();
            ControlFlowGraph cfg = key.cfg();
            TransferFunction<?, ?> transfer = key.transferFunction();
            Analysis analysis = new Analysis(env, transfer);
            analysis.performAnalysis(cfg);
            return analysis;
        }
    });
    private static final LoadingCache<CfgParams, ControlFlowGraph> cfgCache = CacheBuilder.newBuilder().maximumSize(1L).build((CacheLoader)new CacheLoader<CfgParams, ControlFlowGraph>(){

        public ControlFlowGraph load(CfgParams key) {
            UnderlyingAST.CFGLambda ast;
            TreePath methodPath = key.methodPath();
            if (methodPath.getLeaf() instanceof LambdaExpressionTree) {
                ast = new UnderlyingAST.CFGLambda((LambdaExpressionTree)methodPath.getLeaf());
            } else {
                MethodTree method = (MethodTree)methodPath.getLeaf();
                ast = new UnderlyingAST.CFGMethod(method, null);
            }
            ProcessingEnvironment env = key.environment();
            analysisCache.invalidateAll();
            CompilationUnitTree root = methodPath.getCompilationUnit();
            return CFGBuilder.build((CompilationUnitTree)root, (ProcessingEnvironment)env, (UnderlyingAST)ast, (boolean)false, (boolean)false);
        }
    });

    private static <T> TreePath findEnclosingMethodOrLambda(TreePath path) {
        while (path != null) {
            if (path.getLeaf() instanceof MethodTree || path.getLeaf() instanceof LambdaExpressionTree) {
                return path;
            }
            path = path.getParentPath();
        }
        return null;
    }

    private static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> Result<A, S, T> methodDataflow(TreePath methodPath, Context context, T transfer) {
        JavacProcessingEnvironment env = JavacProcessingEnvironment.instance(context);
        final ControlFlowGraph cfg = (ControlFlowGraph)cfgCache.getUnchecked((Object)CfgParams.create(methodPath, env));
        AnalysisParams aparams = AnalysisParams.create(transfer, cfg, env);
        final Analysis analysis = (Analysis)analysisCache.getUnchecked((Object)aparams);
        return new Result<A, S, T>(){

            @Override
            public Analysis<A, S, T> getAnalysis() {
                return analysis;
            }

            @Override
            public ControlFlowGraph getControlFlowGraph() {
                return cfg;
            }
        };
    }

    @Nullable
    public static <A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> A expressionDataflow(TreePath exprPath, Context context, T transfer) {
        Tree leaf = exprPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof ExpressionTree), (String)"Leaf of exprPath must be of type ExpressionTree, but was %s", (Object)leaf.getClass().getName());
        ExpressionTree expr = (ExpressionTree)leaf;
        TreePath enclosingMethodPath = DataFlow.findEnclosingMethodOrLambda(exprPath);
        if (enclosingMethodPath == null) {
            return null;
        }
        Tree method = enclosingMethodPath.getLeaf();
        if (method instanceof MethodTree && ((MethodTree)method).getBody() == null) {
            return null;
        }
        return (A)DataFlow.methodDataflow(enclosingMethodPath, context, transfer).getAnalysis().getValue((Tree)expr);
    }

    static abstract class AnalysisParams {
        private ProcessingEnvironment environment;

        AnalysisParams() {
        }

        abstract TransferFunction<?, ?> transferFunction();

        abstract ControlFlowGraph cfg();

        private static AnalysisParams create(TransferFunction<?, ?> transferFunction, ControlFlowGraph cfg, ProcessingEnvironment environment) {
            AutoValue_DataFlow_AnalysisParams ap = new AutoValue_DataFlow_AnalysisParams(transferFunction, cfg);
            ap.environment = environment;
            return ap;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }
    }

    static abstract class CfgParams {
        private ProcessingEnvironment environment;

        CfgParams() {
        }

        abstract TreePath methodPath();

        private static CfgParams create(TreePath methodPath, ProcessingEnvironment environment) {
            AutoValue_DataFlow_CfgParams cp = new AutoValue_DataFlow_CfgParams(methodPath);
            cp.environment = environment;
            return cp;
        }

        ProcessingEnvironment environment() {
            return this.environment;
        }
    }

    public static interface Result<A extends AbstractValue<A>, S extends Store<S>, T extends TransferFunction<A, S>> {
        public Analysis<A, S, T> getAnalysis();

        public ControlFlowGraph getControlFlowGraph();
    }
}

