/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import java.util.Map;

public final class MapOfProducerProducer<K, V>
extends AbstractProducer<Map<K, Producer<V>>> {
    private static final MapOfProducerProducer<Object, Object> EMPTY = new MapOfProducerProducer(ImmutableMap.of());
    private final ImmutableMap<K, Producer<V>> contributingMap;

    public static <K, V> Builder<K, V> builder(int size) {
        return new Builder(size);
    }

    public static <K, V> MapOfProducerProducer<K, V> empty() {
        return EMPTY;
    }

    private MapOfProducerProducer(ImmutableMap<K, Producer<V>> contributingMap) {
        this.contributingMap = contributingMap;
    }

    @Override
    public ListenableFuture<Map<K, Producer<V>>> compute() {
        return Futures.immediateFuture(this.contributingMap);
    }

    public static final class Builder<K, V> {
        private final Map<K, Producer<V>> mapBuilder;

        private Builder(int size) {
            this.mapBuilder = Maps.newLinkedHashMapWithExpectedSize((int)size);
        }

        public MapOfProducerProducer<K, V> build() {
            return new MapOfProducerProducer(ImmutableMap.copyOf(this.mapBuilder));
        }

        public Builder<K, V> put(K key, Producer<V> producerOfValue) {
            Preconditions.checkNotNull(key, (Object)"key");
            Preconditions.checkNotNull(producerOfValue, (Object)"producer of value");
            this.mapBuilder.put(key, producerOfValue);
            return this;
        }
    }
}

