/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.IterableSubject;
import javax.annotation.Nullable;

public final class MultisetSubject
extends IterableSubject {
    MultisetSubject(FailureStrategy failureStrategy, @Nullable Multiset<?> multiset) {
        super(failureStrategy, (Iterable<?>)multiset);
    }

    @Override
    public MultisetSubject named(String format, Object ... args) {
        super.named(format, args);
        return this;
    }

    public final void hasCount(@Nullable Object element, int expectedCount) {
        Preconditions.checkArgument((expectedCount >= 0 ? 1 : 0) != 0, (String)"expectedCount(%s) must be >= 0", (int)expectedCount);
        int actualCount = ((Multiset)this.actual()).count(element);
        if (actualCount != expectedCount) {
            this.failWithBadResults("has a count for <" + element + "> of", expectedCount, "is", actualCount);
        }
    }
}

