/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.google.AbstractMultisetTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

@GwtCompatible
public class MultisetAddTester<E>
extends AbstractMultisetTester<E> {
    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddUnsupported() {
        try {
            this.getMultiset().add(this.e0());
            MultisetAddTester.fail((String)"Expected UnsupportedOperationException");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddMeansAddOne() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertTrue((boolean)this.getMultiset().add(this.e0()));
        MultisetAddTester.assertEquals((int)(originalCount + 1), (int)this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrencesZero() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertEquals((String)"old count", (int)originalCount, (int)this.getMultiset().add(this.e0(), 0));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrences() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertEquals((String)"old count", (int)originalCount, (int)this.getMultiset().add(this.e0(), 2));
        MultisetAddTester.assertEquals((String)"old count", (int)(originalCount + 2), (int)this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddSeveralTimes() {
        int originalCount = this.getMultiset().count(this.e0());
        MultisetAddTester.assertEquals((int)originalCount, (int)this.getMultiset().add(this.e0(), 2));
        MultisetAddTester.assertTrue((boolean)this.getMultiset().add(this.e0()));
        MultisetAddTester.assertEquals((int)(originalCount + 3), (int)this.getMultiset().add(this.e0(), 1));
        MultisetAddTester.assertEquals((int)(originalCount + 4), (int)this.getMultiset().count(this.e0()));
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrences_unsupported() {
        try {
            this.getMultiset().add(this.e0(), 2);
            MultisetAddTester.fail((String)"unsupported multiset.add(E, int) didn't throw exception");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddOccurrencesNegative() {
        try {
            this.getMultiset().add(this.e0(), -1);
            MultisetAddTester.fail((String)"multiset.add(E, -1) didn't throw an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddTooMany() {
        this.getMultiset().add(this.e3(), Integer.MAX_VALUE);
        try {
            this.getMultiset().add(this.e3());
            MultisetAddTester.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MultisetAddTester.assertEquals((int)Integer.MAX_VALUE, (int)this.getMultiset().count(this.e3()));
        MultisetAddTester.assertEquals((int)Integer.MAX_VALUE, (int)this.getMultiset().size());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_emptySet() {
        MultisetAddTester.assertFalse((boolean)this.getMultiset().addAll(Collections.emptySet()));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_emptyMultiset() {
        MultisetAddTester.assertFalse((boolean)this.getMultiset().addAll((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(new Object[0])));
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_nonEmptyList() {
        MultisetAddTester.assertTrue((boolean)this.getMultiset().addAll(Arrays.asList(this.e3(), this.e4(), this.e3())));
        this.expectAdded(this.e3(), this.e4(), this.e3());
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_ADD})
    public void testAddAll_nonEmptyMultiset() {
        MultisetAddTester.assertTrue((boolean)this.getMultiset().addAll((Collection)((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(this.e3(), this.e4(), this.e3())));
        this.expectAdded(this.e3(), this.e4(), this.e3());
    }
}

