/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;

@BugPattern(name="JUnit3TestNotRun", summary="Test method will not be run; please prefix name with \"test\"", explanation="JUnit 3 requires that test method names start with \"test\". The method that triggered this error looks like it is supposed to be the test, but either misspells the required prefix, or has @Test annotation, but no prefix. As a consequence, JUnit 3 will ignore it.\n\nIf you want to disable test on purpose, change the name to something more descriptive, like \"disabledTestSomething()\". You don't need @Test annotation, but if you want to keep it, add @Ignore too.", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.ERROR)
public class JUnit3TestNotRun
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final Pattern MISSPELLED_NAME = Pattern.compile("t.est|te.st|tst|tet|tes|etst|tset|tets|t.st|te.t|[tT][eE][sS][tT]");

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        String fixedName;
        com.google.errorprone.matchers.Matcher methodMatcher = Matchers.allOf((com.google.errorprone.matchers.Matcher[])new com.google.errorprone.matchers.Matcher[]{Matchers.not((com.google.errorprone.matchers.Matcher)Matchers.methodNameStartsWith((String)"test")), Matchers.hasModifier((Modifier)Modifier.PUBLIC), Matchers.methodReturns((Supplier)Suppliers.VOID_TYPE), Matchers.methodHasParameters((com.google.errorprone.matchers.Matcher[])new com.google.errorprone.matchers.Matcher[0]), Matchers.enclosingClass((com.google.errorprone.matchers.Matcher)JUnitMatchers.isJUnit3TestClass)});
        if (!methodMatcher.matches((Tree)methodTree, state)) {
            return Description.NO_MATCH;
        }
        String name = methodTree.getName().toString();
        Matcher matcher = MISSPELLED_NAME.matcher(name);
        if (matcher.lookingAt()) {
            fixedName = matcher.replaceFirst("test");
        } else if (JUnitMatchers.wouldRunInJUnit4.matches((Tree)methodTree, state)) {
            fixedName = "test" + name.substring(0, 1).toUpperCase() + name.substring(1);
        } else {
            return Description.NO_MATCH;
        }
        JCTree.JCMethodDecl decl = (JCTree.JCMethodDecl)methodTree;
        SuggestedFix fix = SuggestedFix.replace((int)(decl.restype.getStartPosition() + 4), (int)decl.body.getStartPosition(), (String)(" " + fixedName + "() "));
        return this.describeMatch(methodTree, (Fix)fix);
    }
}

