/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="ImmutableEnumChecker", altNames={"Immutable"}, category=BugPattern.Category.JDK, summary="Enums should always be immutable", severity=BugPattern.SeverityLevel.WARNING)
public class ImmutableEnumChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public static final String ANNOTATED_ENUM_MESSAGE = "enums are immutable by default; annotating them with @Immutable is unnecessary";

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableAnalysis.Violation info;
        Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
        if (symbol == null || !symbol.isEnum()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)symbol, Immutable.class, (VisitorState)state) && !ImmutableEnumChecker.implementsImmutableInterface(symbol)) {
            AnnotationTree annotation = ASTHelpers.getAnnotationWithSimpleName(tree.getModifiers().getAnnotations(), (String)"Immutable");
            if (annotation != null) {
                state.reportMatch(this.buildDescription(annotation).setMessage(ANNOTATED_ENUM_MESSAGE).addFix((Fix)SuggestedFix.delete((Tree)annotation)).build());
            } else {
                state.reportMatch(this.buildDescription(tree).setMessage(ANNOTATED_ENUM_MESSAGE).build());
            }
        }
        if (!(info = new ImmutableAnalysis(this, state, "enums should be immutable, and cannot have non-final fields", "enums should only have immutable fields").checkForImmutability((Optional<ClassTree>)Optional.of((Object)tree), (ImmutableSet<String>)ImmutableSet.of(), ASTHelpers.getType((ClassTree)tree))).isPresent()) {
            return Description.NO_MATCH;
        }
        String message = "enums should be immutable: " + info.message();
        return this.buildDescription(tree).setMessage(message).build();
    }

    private static boolean implementsImmutableInterface(Symbol.ClassSymbol symbol) {
        return symbol.getInterfaces().stream().anyMatch(iface -> iface.asElement().getAnnotation(Immutable.class) != null);
    }
}

