/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.stats.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public final class DistributionAggregation {
    private final long count;
    private final double mean;
    private final double sum;
    private final Range range;
    private final List<Tag> tags;
    private final List<Long> bucketCounts;

    public static final DistributionAggregation create(long l, double d, double d2, Range range, List<Tag> list) {
        return new DistributionAggregation(l, d, d2, range, list, null);
    }

    public static final DistributionAggregation create(long l, double d, double d2, Range range, List<Tag> list, List<Long> list2) {
        return new DistributionAggregation(l, d, d2, range, list, Collections.unmodifiableList(new ArrayList<Long>(list2)));
    }

    public final List<Tag> getTags() {
        return this.tags;
    }

    public long getCount() {
        return this.count;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSum() {
        return this.sum;
    }

    public Range getRange() {
        return this.range;
    }

    @Nullable
    public List<Long> getBucketCounts() {
        return this.bucketCounts;
    }

    private DistributionAggregation(long l, double d, double d2, Range range, List<Tag> list, @Nullable List<Long> list2) {
        this.count = l;
        this.mean = d;
        this.sum = d2;
        this.range = range;
        this.tags = list;
        this.bucketCounts = list2;
    }

    public static final class Range {
        private double min;
        private double max;

        public static final Range create(double d, double d2) {
            return new Range(d, d2);
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        private Range(double d, double d2) {
            this.min = d;
            this.max = d2;
        }
    }
}

