/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.BasicDiagnosticFormatter;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class JCDiagnostic
implements Diagnostic<JavaFileObject> {
    private final DiagnosticType type;
    private final DiagnosticSource source;
    private final DiagnosticPosition position;
    private final String key;
    protected final Object[] args;
    private final Set<DiagnosticFlag> flags;
    private final Lint.LintCategory lintCategory;
    private SourcePosition sourcePosition;
    private DiagnosticFormatter<JCDiagnostic> defaultFormatter;
    @Deprecated
    private static DiagnosticFormatter<JCDiagnostic> fragmentFormatter;

    @Deprecated
    public static JCDiagnostic fragment(String string, Object ... objectArray) {
        return new JCDiagnostic(JCDiagnostic.getFragmentFormatter(), DiagnosticType.FRAGMENT, null, EnumSet.noneOf(DiagnosticFlag.class), null, null, "compiler." + DiagnosticType.FRAGMENT.key + "." + string, objectArray);
    }

    @Deprecated
    public static DiagnosticFormatter<JCDiagnostic> getFragmentFormatter() {
        if (fragmentFormatter == null) {
            fragmentFormatter = new BasicDiagnosticFormatter(JavacMessages.getDefaultMessages());
        }
        return fragmentFormatter;
    }

    protected JCDiagnostic(DiagnosticFormatter<JCDiagnostic> diagnosticFormatter, DiagnosticType diagnosticType, Lint.LintCategory lintCategory, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        if (diagnosticSource == null && diagnosticPosition != null && diagnosticPosition.getPreferredPosition() != -1) {
            throw new IllegalArgumentException();
        }
        this.defaultFormatter = diagnosticFormatter;
        this.type = diagnosticType;
        this.lintCategory = lintCategory;
        this.flags = set;
        this.source = diagnosticSource;
        this.position = diagnosticPosition;
        this.key = string;
        this.args = objectArray;
    }

    public DiagnosticType getType() {
        return this.type;
    }

    public List<JCDiagnostic> getSubdiagnostics() {
        return List.nil();
    }

    public boolean isMultiline() {
        return false;
    }

    public boolean isMandatory() {
        return this.flags.contains((Object)DiagnosticFlag.MANDATORY);
    }

    public boolean hasLintCategory() {
        return this.lintCategory != null;
    }

    public Lint.LintCategory getLintCategory() {
        return this.lintCategory;
    }

    @Override
    public JavaFileObject getSource() {
        if (this.source == null) {
            return null;
        }
        return this.source.getFile();
    }

    public DiagnosticSource getDiagnosticSource() {
        return this.source;
    }

    protected int getIntStartPosition() {
        return this.position == null ? -1 : this.position.getStartPosition();
    }

    protected int getIntPosition() {
        return this.position == null ? -1 : this.position.getPreferredPosition();
    }

    protected int getIntEndPosition() {
        return this.position == null ? -1 : this.position.getEndPosition(this.source.getEndPosTable());
    }

    @Override
    public long getStartPosition() {
        return this.getIntStartPosition();
    }

    @Override
    public long getPosition() {
        return this.getIntPosition();
    }

    @Override
    public long getEndPosition() {
        return this.getIntEndPosition();
    }

    public DiagnosticPosition getDiagnosticPosition() {
        return this.position;
    }

    @Override
    public long getLineNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getLineNumber();
    }

    @Override
    public long getColumnNumber() {
        if (this.sourcePosition == null) {
            this.sourcePosition = new SourcePosition();
        }
        return this.sourcePosition.getColumnNumber();
    }

    public Object[] getArgs() {
        return this.args;
    }

    public String getPrefix() {
        return this.getPrefix(this.type);
    }

    public String getPrefix(DiagnosticType diagnosticType) {
        return this.defaultFormatter.formatKind(this, Locale.getDefault());
    }

    public String toString() {
        return this.defaultFormatter.format(this, Locale.getDefault());
    }

    @Override
    public Diagnostic.Kind getKind() {
        switch (this.type) {
            case NOTE: {
                return Diagnostic.Kind.NOTE;
            }
            case WARNING: {
                return this.flags.contains((Object)DiagnosticFlag.MANDATORY) ? Diagnostic.Kind.MANDATORY_WARNING : Diagnostic.Kind.WARNING;
            }
            case ERROR: {
                return Diagnostic.Kind.ERROR;
            }
        }
        return Diagnostic.Kind.OTHER;
    }

    @Override
    public String getCode() {
        return this.key;
    }

    @Override
    public String getMessage(Locale locale) {
        return this.defaultFormatter.formatMessage(this, locale);
    }

    public void setFlag(DiagnosticFlag diagnosticFlag) {
        this.flags.add(diagnosticFlag);
        if (this.type == DiagnosticType.ERROR) {
            switch (diagnosticFlag) {
                case SYNTAX: {
                    this.flags.remove((Object)DiagnosticFlag.RECOVERABLE);
                    break;
                }
                case RESOLVE_ERROR: {
                    this.flags.add(DiagnosticFlag.RECOVERABLE);
                }
            }
        }
    }

    public boolean isFlagSet(DiagnosticFlag diagnosticFlag) {
        return this.flags.contains((Object)diagnosticFlag);
    }

    public static class MultilineDiagnostic
    extends JCDiagnostic {
        private final List<JCDiagnostic> subdiagnostics;

        public MultilineDiagnostic(JCDiagnostic jCDiagnostic, List<JCDiagnostic> list) {
            super(jCDiagnostic.defaultFormatter, jCDiagnostic.getType(), jCDiagnostic.getLintCategory(), jCDiagnostic.flags, jCDiagnostic.getDiagnosticSource(), jCDiagnostic.position, jCDiagnostic.getCode(), jCDiagnostic.getArgs());
            this.subdiagnostics = list;
        }

        @Override
        public List<JCDiagnostic> getSubdiagnostics() {
            return this.subdiagnostics;
        }

        @Override
        public boolean isMultiline() {
            return true;
        }
    }

    class SourcePosition {
        private final int line;
        private final int column;

        SourcePosition() {
            int n;
            int n2 = n = JCDiagnostic.this.position == null ? -1 : JCDiagnostic.this.position.getPreferredPosition();
            if (n == -1 || JCDiagnostic.this.source == null) {
                this.column = -1;
                this.line = -1;
            } else {
                this.line = JCDiagnostic.this.source.getLineNumber(n);
                this.column = JCDiagnostic.this.source.getColumnNumber(n, true);
            }
        }

        public int getLineNumber() {
            return this.line;
        }

        public int getColumnNumber() {
            return this.column;
        }
    }

    public static enum DiagnosticFlag {
        MANDATORY,
        RESOLVE_ERROR,
        SYNTAX,
        RECOVERABLE,
        NON_DEFERRABLE,
        COMPRESSED;

    }

    public static class SimpleDiagnosticPosition
    implements DiagnosticPosition {
        private final int pos;

        public SimpleDiagnosticPosition(int n) {
            this.pos = n;
        }

        @Override
        public JCTree getTree() {
            return null;
        }

        @Override
        public int getStartPosition() {
            return this.pos;
        }

        @Override
        public int getPreferredPosition() {
            return this.pos;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            return this.pos;
        }
    }

    public static interface DiagnosticPosition {
        public JCTree getTree();

        public int getStartPosition();

        public int getPreferredPosition();

        public int getEndPosition(EndPosTable var1);
    }

    public static enum DiagnosticType {
        FRAGMENT("misc"),
        NOTE("note"),
        WARNING("warn"),
        ERROR("err");

        final String key;

        private DiagnosticType(String string2) {
            this.key = string2;
        }
    }

    public static class Factory {
        protected static final Context.Key<Factory> diagnosticFactoryKey = new Context.Key();
        DiagnosticFormatter<JCDiagnostic> formatter;
        final String prefix;
        final Set<DiagnosticFlag> defaultErrorFlags;

        public static Factory instance(Context context) {
            Factory factory = context.get(diagnosticFactoryKey);
            if (factory == null) {
                factory = new Factory(context);
            }
            return factory;
        }

        protected Factory(Context context) {
            this(JavacMessages.instance(context), "compiler");
            context.put(diagnosticFactoryKey, this);
            final Options options = Options.instance(context);
            this.initOptions(options);
            options.addListener(new Runnable(){

                @Override
                public void run() {
                    Factory.this.initOptions(options);
                }
            });
        }

        private void initOptions(Options options) {
            if (options.isSet("onlySyntaxErrorsUnrecoverable")) {
                this.defaultErrorFlags.add(DiagnosticFlag.RECOVERABLE);
            }
        }

        public Factory(JavacMessages javacMessages, String string) {
            this.prefix = string;
            this.formatter = new BasicDiagnosticFormatter(javacMessages);
            this.defaultErrorFlags = EnumSet.of(DiagnosticFlag.MANDATORY);
        }

        public JCDiagnostic error(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(DiagnosticType.ERROR, null, this.defaultErrorFlags, diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic mandatoryWarning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(DiagnosticType.WARNING, null, EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic mandatoryWarning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(DiagnosticType.WARNING, lintCategory, EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic warning(Lint.LintCategory lintCategory, String string, Object ... objectArray) {
            return this.create(DiagnosticType.WARNING, lintCategory, EnumSet.noneOf(DiagnosticFlag.class), null, null, string, objectArray);
        }

        public JCDiagnostic warning(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(DiagnosticType.WARNING, null, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic warning(Lint.LintCategory lintCategory, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(DiagnosticType.WARNING, lintCategory, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic mandatoryNote(DiagnosticSource diagnosticSource, String string, Object ... objectArray) {
            return this.create(DiagnosticType.NOTE, null, EnumSet.of(DiagnosticFlag.MANDATORY), diagnosticSource, null, string, objectArray);
        }

        public JCDiagnostic note(String string, Object ... objectArray) {
            return this.create(DiagnosticType.NOTE, null, EnumSet.noneOf(DiagnosticFlag.class), null, null, string, objectArray);
        }

        public JCDiagnostic note(DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(DiagnosticType.NOTE, null, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic fragment(String string, Object ... objectArray) {
            return this.create(DiagnosticType.FRAGMENT, null, EnumSet.noneOf(DiagnosticFlag.class), null, null, string, objectArray);
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return this.create(diagnosticType, null, EnumSet.noneOf(DiagnosticFlag.class), diagnosticSource, diagnosticPosition, string, objectArray);
        }

        public JCDiagnostic create(DiagnosticType diagnosticType, Lint.LintCategory lintCategory, Set<DiagnosticFlag> set, DiagnosticSource diagnosticSource, DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
            return new JCDiagnostic(this.formatter, diagnosticType, lintCategory, set, diagnosticSource, diagnosticPosition, this.qualify(diagnosticType, string), objectArray);
        }

        protected String qualify(DiagnosticType diagnosticType, String string) {
            return this.prefix + "." + diagnosticType.key + "." + string;
        }
    }
}

