/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.CanonicalTypeBinder;
import com.google.turbine.binder.ClassPathBinder;
import com.google.turbine.binder.CompUnitPreprocessor;
import com.google.turbine.binder.ConstBinder;
import com.google.turbine.binder.ConstEvaluator;
import com.google.turbine.binder.DisambiguateTypeAnnotations;
import com.google.turbine.binder.HierarchyBinder;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.TypeBinder;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.PackageSourceBoundClass;
import com.google.turbine.binder.bound.SourceBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.ImportIndex;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.lookup.WildImportIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.model.Const;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.Type;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;

public class Binder {
    public static BindingResult bind(List<Tree.CompUnit> units, Collection<Path> classpath, Collection<Path> bootclasspath) throws IOException {
        ImmutableList<CompUnitPreprocessor.PreprocessedCompUnit> preProcessedUnits = CompUnitPreprocessor.preprocess(units);
        TopLevelIndex.Builder tliBuilder = TopLevelIndex.builder();
        SimpleEnv<ClassSymbol, SourceBoundClass> ienv = Binder.bindSourceBoundClasses(preProcessedUnits, tliBuilder);
        ImmutableSet syms = ienv.asMap().keySet();
        CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv = ClassPathBinder.bind(classpath, bootclasspath, tliBuilder);
        TopLevelIndex tli = tliBuilder.build();
        SimpleEnv<ClassSymbol, PackageSourceBoundClass> psenv = Binder.bindPackages(ienv, tli, preProcessedUnits, classPathEnv);
        Env<ClassSymbol, SourceHeaderBoundClass> henv = Binder.bindHierarchy((Iterable<ClassSymbol>)syms, psenv, classPathEnv);
        Env<ClassSymbol, SourceTypeBoundClass> tenv = Binder.bindTypes((ImmutableSet<ClassSymbol>)syms, henv, CompoundEnv.of(classPathEnv).append(henv));
        tenv = Binder.constants((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        tenv = Binder.disambiguateTypeAnnotations((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        tenv = Binder.canonicalizeTypes((ImmutableSet<ClassSymbol>)syms, tenv, CompoundEnv.of(classPathEnv).append(tenv));
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ClassSymbol sym : syms) {
            result.put((Object)sym, (Object)tenv.get(sym));
        }
        return new BindingResult((ImmutableMap<ClassSymbol, SourceTypeBoundClass>)result.build(), classPathEnv);
    }

    static SimpleEnv<ClassSymbol, SourceBoundClass> bindSourceBoundClasses(ImmutableList<CompUnitPreprocessor.PreprocessedCompUnit> units, TopLevelIndex.Builder tliBuilder) {
        SimpleEnv.Builder<ClassSymbol, SourceBoundClass> envBuilder = SimpleEnv.builder();
        for (CompUnitPreprocessor.PreprocessedCompUnit unit : units) {
            for (SourceBoundClass type : unit.types()) {
                envBuilder.put(type.sym(), type);
                tliBuilder.insert(type.sym());
            }
        }
        return envBuilder.build();
    }

    private static SimpleEnv<ClassSymbol, PackageSourceBoundClass> bindPackages(Env<ClassSymbol, SourceBoundClass> ienv, TopLevelIndex tli, ImmutableList<CompUnitPreprocessor.PreprocessedCompUnit> units, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
        SimpleEnv.Builder<ClassSymbol, PackageSourceBoundClass> env = SimpleEnv.builder();
        Scope javaLang = (Scope)Verify.verifyNotNull((Object)tli.lookupPackage((ImmutableList<String>)ImmutableList.of((Object)"java", (Object)"lang")));
        CompoundScope topLevel = CompoundScope.base(tli).append(javaLang);
        for (CompUnitPreprocessor.PreprocessedCompUnit unit : units) {
            ImmutableList packagename = ImmutableList.copyOf((Iterable)Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)unit.packageName()));
            Scope packageScope = tli.lookupPackage((ImmutableList<String>)packagename);
            Resolve.CanonicalResolver importResolver = new Resolve.CanonicalResolver((ImmutableList<String>)packagename, CompoundEnv.of(classPathEnv).append(ienv));
            ImportIndex importScope = ImportIndex.create(importResolver, tli, unit.imports());
            WildImportIndex wildImportScope = WildImportIndex.create(importResolver, tli, unit.imports());
            MemberImportIndex memberImports = new MemberImportIndex(importResolver, tli, unit.imports());
            ImportScope scope = ImportScope.fromScope(topLevel).append(wildImportScope).append(ImportScope.fromScope(packageScope)).append(importScope);
            for (SourceBoundClass type : unit.types()) {
                env.put(type.sym(), new PackageSourceBoundClass(type, scope, memberImports, unit.source()));
            }
        }
        return env.build();
    }

    private static Env<ClassSymbol, SourceHeaderBoundClass> bindHierarchy(Iterable<ClassSymbol> syms, final SimpleEnv<ClassSymbol, PackageSourceBoundClass> psenv, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
        ImmutableMap.Builder completers = ImmutableMap.builder();
        for (ClassSymbol sym : syms) {
            completers.put((Object)sym, (Object)new LazyEnv.Completer<ClassSymbol, HeaderBoundClass, SourceHeaderBoundClass>(){

                @Override
                public SourceHeaderBoundClass complete(Env<ClassSymbol, HeaderBoundClass> henv, ClassSymbol sym) {
                    return HierarchyBinder.bind(sym, (PackageSourceBoundClass)psenv.get(sym), henv);
                }
            });
        }
        return new LazyEnv(completers.build(), classPathEnv);
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> bindTypes(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceHeaderBoundClass> shenv, Env<ClassSymbol, HeaderBoundClass> henv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.put(sym, TypeBinder.bind(henv, sym, shenv.get(sym)));
        }
        return builder.build();
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> canonicalizeTypes(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> stenv, Env<ClassSymbol, TypeBoundClass> tenv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.put(sym, CanonicalTypeBinder.bind(sym, stenv.get(sym), tenv));
        }
        return builder.build();
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> constants(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> env, final CompoundEnv<ClassSymbol, TypeBoundClass> baseEnv) {
        ImmutableMap.Builder completers = ImmutableMap.builder();
        for (final ClassSymbol sym : syms) {
            final SourceTypeBoundClass info = env.get(sym);
            for (final TypeBoundClass.FieldInfo field : info.fields()) {
                if (!Binder.isConst(field)) continue;
                completers.put((Object)field.sym(), (Object)new LazyEnv.Completer<FieldSymbol, Const.Value, Const.Value>(){

                    @Override
                    public Const.Value complete(Env<FieldSymbol, Const.Value> env1, FieldSymbol k) {
                        try {
                            return new ConstEvaluator(sym, sym, info, info.scope(), env1, baseEnv).evalFieldInitializer((Tree.Expression)field.decl().init().get(), field.type());
                        }
                        catch (LazyEnv.LazyBindingError e) {
                            return null;
                        }
                    }
                });
            }
        }
        LazyEnv constenv = new LazyEnv(completers.build(), SimpleEnv.builder().build());
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.put(sym, new ConstBinder(constenv, sym, baseEnv, env.get(sym)).bind());
        }
        return builder.build();
    }

    static boolean isConst(TypeBoundClass.FieldInfo field) {
        if ((field.access() & 0x10) == 0) {
            return false;
        }
        if (field.decl() == null) {
            return false;
        }
        Optional<Tree.Expression> init = field.decl().init();
        if (!init.isPresent()) {
            return false;
        }
        switch (field.type().tyKind()) {
            case PRIM_TY: {
                break;
            }
            case CLASS_TY: {
                if (((Type.ClassTy)field.type()).sym().equals(ClassSymbol.STRING)) break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    private static Env<ClassSymbol, SourceTypeBoundClass> disambiguateTypeAnnotations(ImmutableSet<ClassSymbol> syms, Env<ClassSymbol, SourceTypeBoundClass> stenv, Env<ClassSymbol, TypeBoundClass> tenv) {
        SimpleEnv.Builder<ClassSymbol, SourceTypeBoundClass> builder = SimpleEnv.builder();
        for (ClassSymbol sym : syms) {
            builder.put(sym, DisambiguateTypeAnnotations.bind(stenv.get(sym), tenv));
        }
        return builder.build();
    }

    public static class BindingResult {
        private final ImmutableMap<ClassSymbol, SourceTypeBoundClass> units;
        private final CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv;

        public BindingResult(ImmutableMap<ClassSymbol, SourceTypeBoundClass> units, CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv) {
            this.units = units;
            this.classPathEnv = classPathEnv;
        }

        public ImmutableMap<ClassSymbol, SourceTypeBoundClass> units() {
            return this.units;
        }

        public CompoundEnv<ClassSymbol, BytecodeBoundClass> classPathEnv() {
            return this.classPathEnv;
        }
    }
}

