/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.CommentsHelper;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.Replacement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class JavaOutput
extends Output {
    private final JavaInput javaInput;
    private final CommentsHelper commentsHelper;
    private final Map<Integer, OpsBuilder.BlankLineWanted> blankLines = new HashMap<Integer, OpsBuilder.BlankLineWanted>();
    private final NavigableSet<Integer> partialFormatBoundaries = new TreeSet<Integer>();
    private final List<String> mutableLines = new ArrayList<String>();
    private final int kN;
    private int iLine = 0;
    private int lastK = -1;
    private int spacesPending = 0;
    private int newlinesPending = 0;
    private StringBuilder lineBuilder = new StringBuilder();

    public JavaOutput(JavaInput javaInput, CommentsHelper commentsHelper) {
        this.javaInput = javaInput;
        this.commentsHelper = commentsHelper;
        this.kN = javaInput.getkN();
    }

    @Override
    public void blankLine(int k, OpsBuilder.BlankLineWanted wanted) {
        if (this.blankLines.containsKey(k)) {
            this.blankLines.put(k, this.blankLines.get(k).merge(wanted));
        } else {
            this.blankLines.put(k, wanted);
        }
    }

    @Override
    public void markForPartialFormat(int k) {
        this.partialFormatBoundaries.add(k);
    }

    @Override
    public void append(String text, Range<Integer> range) {
        if (!range.isEmpty()) {
            boolean sawNewlines = false;
            int iN = this.javaInput.getLineCount();
            while (this.iLine < iN && (this.javaInput.getRange1s(this.iLine).isEmpty() || (Integer)this.javaInput.getRange1s(this.iLine).upperEndpoint() <= (Integer)range.lowerEndpoint())) {
                if (this.javaInput.getRanges(this.iLine).isEmpty()) {
                    sawNewlines = true;
                }
                ++this.iLine;
            }
            OpsBuilder.BlankLineWanted wanted = (OpsBuilder.BlankLineWanted)MoreObjects.firstNonNull((Object)this.blankLines.get(this.lastK), (Object)OpsBuilder.BlankLineWanted.NO);
            if (this.isComment(text) ? sawNewlines : (Boolean)wanted.wanted().or((Object)sawNewlines) != false) {
                ++this.newlinesPending;
            }
        }
        if (text.equals("\n")) {
            if (this.newlinesPending == 0) {
                ++this.newlinesPending;
            }
            this.spacesPending = 0;
        } else {
            boolean range0sSet = false;
            boolean rangesSet = false;
            int textN = text.length();
            block5: for (int i = 0; i < textN; ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case ' ': {
                        ++this.spacesPending;
                        continue block5;
                    }
                    case '\n': {
                        this.spacesPending = 0;
                        ++this.newlinesPending;
                        continue block5;
                    }
                    default: {
                        while (this.newlinesPending > 0) {
                            this.mutableLines.add(this.lineBuilder.toString());
                            this.lineBuilder = new StringBuilder();
                            rangesSet = false;
                            --this.newlinesPending;
                        }
                        while (this.spacesPending > 0) {
                            this.lineBuilder.append(' ');
                            --this.spacesPending;
                        }
                        this.lineBuilder.append(c);
                        if (range.isEmpty()) continue block5;
                        if (!range0sSet && !range.isEmpty()) {
                            while (this.range0s.size() <= this.mutableLines.size()) {
                                this.range0s.add(Formatter.EMPTY_RANGE);
                            }
                            this.range0s.set(this.mutableLines.size(), JavaOutput.union((Range<Integer>)((Range)this.range0s.get(this.mutableLines.size())), range));
                            range0sSet = true;
                        }
                        if (rangesSet) continue block5;
                        while (this.ranges.size() <= this.mutableLines.size()) {
                            this.ranges.add(Formatter.EMPTY_RANGE);
                        }
                        this.ranges.set(this.mutableLines.size(), JavaOutput.union((Range<Integer>)((Range)this.ranges.get(this.mutableLines.size())), range));
                        rangesSet = true;
                    }
                }
            }
            if (!range.isEmpty()) {
                while (this.range1s.size() <= this.mutableLines.size()) {
                    this.range1s.add(Formatter.EMPTY_RANGE);
                }
                this.range1s.set(this.mutableLines.size(), JavaOutput.union((Range<Integer>)((Range)this.range1s.get(this.mutableLines.size())), range));
            }
        }
        if (!range.isEmpty()) {
            this.lastK = (Integer)range.upperEndpoint();
        }
    }

    @Override
    public void indent(int indent) {
        this.spacesPending = indent;
    }

    void flush() {
        String lastLine = this.lineBuilder.toString();
        if (!lastLine.isEmpty()) {
            this.mutableLines.add(lastLine);
        }
        int jN = this.mutableLines.size();
        Range eofRange = Range.closedOpen((Comparable)Integer.valueOf(this.kN), (Comparable)Integer.valueOf(this.kN + 1));
        while (this.range0s.size() < jN) {
            this.range0s.add(Formatter.EMPTY_RANGE);
        }
        this.range0s.add(eofRange);
        while (this.ranges.size() < jN) {
            this.ranges.add(Formatter.EMPTY_RANGE);
        }
        this.ranges.add(eofRange);
        while (this.range1s.size() < jN) {
            this.range1s.add(Formatter.EMPTY_RANGE);
        }
        this.range1s.add(eofRange);
        this.setLines((ImmutableList<String>)ImmutableList.copyOf(this.mutableLines));
    }

    @Override
    public CommentsHelper getCommentsHelper() {
        return this.commentsHelper;
    }

    public ImmutableList<Replacement> getFormatReplacements(RangeSet<Integer> iRangeSet0) {
        ImmutableList.Builder result = ImmutableList.builder();
        Map<Integer, Range<Integer>> kToJ = JavaOutput.makeKToIJ(this, this.kN);
        TreeRangeSet breakableRanges = TreeRangeSet.create();
        RangeSet iRangeSet = iRangeSet0.subRangeSet(Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(this.javaInput.getkN())));
        for (Range iRange : iRangeSet.asRanges()) {
            breakableRanges.add(this.expandToBreakableRegions((Range<Integer>)iRange.canonical(DiscreteDomain.integers())));
        }
        for (Range range : breakableRanges.asRanges()) {
            int idx;
            int i;
            char previous;
            int replaceFrom;
            Input.Tok startTok = JavaOutput.startTok(this.javaInput.getToken((Integer)range.lowerEndpoint()));
            Input.Tok endTok = JavaOutput.endTok(this.javaInput.getToken((Integer)range.upperEndpoint() - 1));
            StringBuilder replacement = new StringBuilder();
            boolean needsBreakBefore = false;
            for (replaceFrom = startTok.getPosition(); replaceFrom > 0 && (previous = this.javaInput.getText().charAt(replaceFrom - 1)) != '\n'; --replaceFrom) {
                if (CharMatcher.whitespace().matches(previous)) {
                    continue;
                }
                needsBreakBefore = true;
                break;
            }
            if (needsBreakBefore) {
                replacement.append('\n');
            }
            boolean first = true;
            for (i = ((Integer)kToJ.get(startTok.getIndex()).lowerEndpoint()).intValue(); i < (Integer)kToJ.get(endTok.getIndex()).upperEndpoint(); ++i) {
                if (i >= this.getLineCount()) continue;
                if (first) {
                    first = false;
                } else {
                    replacement.append('\n');
                }
                replacement.append(this.getLine(i));
            }
            replacement.append('\n');
            String trailingLine = i < this.getLineCount() ? this.getLine(i) : null;
            int replaceTo = Math.min(endTok.getPosition() + endTok.getText().length(), this.javaInput.getText().length());
            if (endTok.getIndex() == this.javaInput.getkN() - 1) {
                replaceTo = this.javaInput.getText().length();
            }
            boolean reIndent = true;
            while (replaceTo < this.javaInput.getText().length()) {
                char endChar = this.javaInput.getText().charAt(replaceTo);
                if (endChar == '\n') {
                    reIndent = false;
                    ++replaceTo;
                    break;
                }
                if (!CharMatcher.whitespace().matches(endChar)) break;
                ++replaceTo;
            }
            if (reIndent && trailingLine != null && (idx = CharMatcher.whitespace().negate().indexIn((CharSequence)trailingLine)) > 0) {
                replacement.append(trailingLine, 0, idx);
            }
            result.add((Object)Replacement.create((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(replaceFrom), (Comparable)Integer.valueOf(replaceTo)), replacement.toString()));
        }
        return result.build();
    }

    private Range<Integer> expandToBreakableRegions(Range<Integer> iRange) {
        int loTok = (Integer)iRange.lowerEndpoint();
        int hiTok = (Integer)iRange.upperEndpoint() - 1;
        loTok = (Integer)MoreObjects.firstNonNull((Object)this.partialFormatBoundaries.floor(loTok), this.partialFormatBoundaries.first());
        hiTok = (Integer)MoreObjects.firstNonNull((Object)this.partialFormatBoundaries.higher(hiTok), (Object)((Integer)this.partialFormatBoundaries.last() + 1));
        return Range.closedOpen((Comparable)Integer.valueOf(loTok), (Comparable)Integer.valueOf(hiTok));
    }

    public void writeMerged(Appendable writer, RangeSet<Integer> iRangeSet0) throws IOException {
        ImmutableList<Replacement> replacements = this.getFormatReplacements(iRangeSet0);
        String inputText = this.javaInput.getText();
        int inputIndex = 0;
        for (Replacement replacement : replacements) {
            if (inputIndex < (Integer)replacement.getReplaceRange().lowerEndpoint()) {
                writer.append(inputText.subSequence(inputIndex, (Integer)replacement.getReplaceRange().lowerEndpoint()));
            }
            inputIndex = (Integer)replacement.getReplaceRange().upperEndpoint();
            writer.append(replacement.getReplacementString());
        }
        if (inputIndex < inputText.length()) {
            writer.append(inputText.substring(inputIndex));
        }
    }

    public static int startPosition(Input.Token token) {
        int min = token.getTok().getPosition();
        for (Input.Tok tok : token.getToksBefore()) {
            min = Math.min(min, tok.getPosition());
        }
        return min;
    }

    public static Input.Tok startTok(Input.Token token) {
        for (Input.Tok tok : token.getToksBefore()) {
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token.getTok();
    }

    public static Input.Tok endTok(Input.Token token) {
        for (int i = token.getToksAfter().size() - 1; i >= 0; --i) {
            Input.Tok tok = (Input.Tok)token.getToksAfter().get(i);
            if (tok.getIndex() < 0) continue;
            return tok;
        }
        return token.getTok();
    }

    private boolean isComment(String text) {
        return text.startsWith("//") || text.startsWith("/*");
    }

    private static Range<Integer> union(Range<Integer> x, Range<Integer> y) {
        return x.isEmpty() ? y : (y.isEmpty() ? x : x.span(y).canonical(DiscreteDomain.integers()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("iLine", this.iLine).add("lastK", this.lastK).add("spacesPending", this.spacesPending).add("newlinesPending", this.newlinesPending).add("blankLines", this.blankLines).add("super", (Object)super.toString()).toString();
    }

    static enum From {
        INPUT,
        OUTPUT;

    }
}

