/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.MembersInjector;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.DependencyRequest;
import dagger.producers.Producer;
import javax.inject.Provider;

abstract class DependencyRequestMapper {
    static final DependencyRequestMapper FOR_PROVIDER = new MapperForProvider();
    static final DependencyRequestMapper FOR_PRODUCER = new MapperForProducer();

    DependencyRequestMapper() {
    }

    abstract Class<?> getFrameworkClass(DependencyRequest var1);

    Class<?> getFrameworkClass(Iterable<DependencyRequest> requests) {
        ImmutableSet classes = FluentIterable.from(requests).transform(new Function<DependencyRequest, Class<?>>(){

            public Class<?> apply(DependencyRequest request) {
                return DependencyRequestMapper.this.getFrameworkClass(request);
            }
        }).toSet();
        if (classes.size() == 1) {
            return (Class)Iterables.getOnlyElement((Iterable)classes);
        }
        if (classes.equals((Object)ImmutableSet.of(Producer.class, Provider.class))) {
            return Provider.class;
        }
        String string = String.valueOf(classes);
        throw new IllegalStateException(new StringBuilder(30 + String.valueOf(string).length()).append("Bad set of framework classes: ").append(string).toString());
    }

    static DependencyRequestMapper forBindingType(BindingType bindingType) {
        return bindingType.equals((Object)BindingType.PRODUCTION) ? FOR_PRODUCER : FOR_PROVIDER;
    }

    private static final class MapperForProducer
    extends DependencyRequestMapper {
        private MapperForProducer() {
        }

        @Override
        public Class<?> getFrameworkClass(DependencyRequest request) {
            switch (request.kind()) {
                case INSTANCE: 
                case PRODUCED: 
                case PRODUCER: {
                    return Producer.class;
                }
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return Provider.class;
                }
                case MEMBERS_INJECTOR: {
                    return MembersInjector.class;
                }
            }
            throw new AssertionError();
        }
    }

    private static final class MapperForProvider
    extends DependencyRequestMapper {
        private MapperForProvider() {
        }

        @Override
        public Class<?> getFrameworkClass(DependencyRequest request) {
            switch (request.kind()) {
                case INSTANCE: 
                case PROVIDER: 
                case PROVIDER_OF_LAZY: 
                case LAZY: {
                    return Provider.class;
                }
                case MEMBERS_INJECTOR: {
                    return MembersInjector.class;
                }
                case PRODUCED: 
                case PRODUCER: {
                    throw new IllegalArgumentException();
                }
            }
            throw new AssertionError();
        }
    }
}

