/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.CacheEventContext;
import com.hazelcast.cache.impl.CacheEventDataImpl;
import com.hazelcast.cache.impl.CacheEventSet;
import com.hazelcast.cache.impl.CacheEventType;
import com.hazelcast.cache.impl.client.CacheBatchInvalidationMessage;
import com.hazelcast.cache.impl.client.CacheSingleInvalidationMessage;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class CacheEventHandler {
    private final NodeEngine nodeEngine;
    private boolean invalidationMessageBatchEnabled;
    private int invalidationMessageBatchSize;
    private final ConcurrentMap<String, InvalidationEventQueue> invalidationMessageMap = new ConcurrentHashMap<String, InvalidationEventQueue>();
    private ScheduledFuture cacheBatchInvalidationMessageSenderScheduler;

    CacheEventHandler(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        GroupProperties groupProperties = nodeEngine.getGroupProperties();
        this.invalidationMessageBatchEnabled = groupProperties.getBoolean(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED);
        if (this.invalidationMessageBatchEnabled) {
            this.invalidationMessageBatchSize = groupProperties.getInteger(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE);
            int invalidationMessageBatchFreq = groupProperties.getInteger(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS);
            ExecutionService executionService = nodeEngine.getExecutionService();
            CacheBatchInvalidationMessageSender batchInvalidationMessageSender = new CacheBatchInvalidationMessageSender();
            this.cacheBatchInvalidationMessageSenderScheduler = executionService.scheduleAtFixedRate("hz:impl:cacheService:cacheBatchInvalidationMessageSender", batchInvalidationMessageSender, invalidationMessageBatchFreq, invalidationMessageBatchFreq, TimeUnit.SECONDS);
        }
        LifecycleService lifecycleService = nodeEngine.getHazelcastInstance().getLifecycleService();
        lifecycleService.addLifecycleListener(new LifecycleListener(){

            @Override
            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTTING_DOWN) {
                    CacheEventHandler.this.invalidateAllCaches();
                }
            }
        });
    }

    void publishEvent(CacheEventContext cacheEventContext) {
        IdentifiedDataSerializable eventData;
        String cacheName;
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName = cacheEventContext.getCacheName());
        if (candidates.isEmpty()) {
            return;
        }
        CacheEventType eventType = cacheEventContext.getEventType();
        switch (eventType) {
            case CREATED: 
            case UPDATED: 
            case REMOVED: 
            case EXPIRED: {
                CacheEventDataImpl cacheEventData = new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), cacheEventContext.getDataOldValue(), cacheEventContext.isOldValueAvailable());
                CacheEventSet eventSet = new CacheEventSet(eventType, cacheEventContext.getCompletionId());
                eventSet.addEventData(cacheEventData);
                eventData = eventSet;
                break;
            }
            case EVICTED: 
            case INVALIDATED: {
                eventData = new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), null, null, false);
                break;
            }
            case COMPLETED: {
                CacheEventDataImpl completedEventData = new CacheEventDataImpl(cacheName, eventType, cacheEventContext.getDataKey(), cacheEventContext.getDataValue(), null, false);
                CacheEventSet eventSet = new CacheEventSet(eventType, cacheEventContext.getCompletionId());
                eventSet.addEventData(completedEventData);
                eventData = eventSet;
                break;
            }
            default: {
                throw new IllegalArgumentException("Event Type not defined to create an eventData during publish : " + eventType.name());
            }
        }
        eventService.publishEvent("hz:impl:cacheService", candidates, (Object)eventData, cacheEventContext.getOrderKey());
    }

    void publishEvent(String cacheName, CacheEventSet eventSet, int orderKey) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> candidates = eventService.getRegistrations("hz:impl:cacheService", cacheName);
        if (candidates.isEmpty()) {
            return;
        }
        eventService.publishEvent("hz:impl:cacheService", candidates, (Object)eventSet, orderKey);
    }

    void sendInvalidationEvent(String name, Data key, String sourceUuid) {
        if (key == null) {
            this.sendSingleInvalidationEvent(name, null, sourceUuid);
        } else if (this.invalidationMessageBatchEnabled) {
            this.sendBatchInvalidationEvent(name, key, sourceUuid);
        } else {
            this.sendSingleInvalidationEvent(name, key, sourceUuid);
        }
    }

    void shutdown() {
        if (this.cacheBatchInvalidationMessageSenderScheduler != null) {
            this.cacheBatchInvalidationMessageSenderScheduler.cancel(true);
        }
    }

    private void sendSingleInvalidationEvent(String name, Data key, String sourceUuid) {
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", name);
        if (!registrations.isEmpty()) {
            eventService.publishEvent("hz:impl:cacheService", registrations, (Object)new CacheSingleInvalidationMessage(name, key, sourceUuid), name.hashCode());
        }
    }

    private void sendBatchInvalidationEvent(String name, Data key, String sourceUuid) {
        InvalidationEventQueue newInvalidationMessageQueue;
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", name);
        if (registrations.isEmpty()) {
            return;
        }
        InvalidationEventQueue invalidationMessageQueue = (InvalidationEventQueue)this.invalidationMessageMap.get(name);
        if (invalidationMessageQueue == null && (invalidationMessageQueue = this.invalidationMessageMap.putIfAbsent(name, newInvalidationMessageQueue = new InvalidationEventQueue())) == null) {
            invalidationMessageQueue = newInvalidationMessageQueue;
        }
        CacheSingleInvalidationMessage invalidationMessage = new CacheSingleInvalidationMessage(name, key, sourceUuid);
        invalidationMessageQueue.offer(invalidationMessage);
        if (invalidationMessageQueue.size() >= this.invalidationMessageBatchSize) {
            this.flushInvalidationMessages(name, invalidationMessageQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInvalidationMessages(String cacheName, InvalidationEventQueue invalidationMessageQueue) {
        if (invalidationMessageQueue.tryAcquire()) {
            try {
                CacheSingleInvalidationMessage invalidationMessage;
                CacheBatchInvalidationMessage batchInvalidationMessage = new CacheBatchInvalidationMessage(cacheName, invalidationMessageQueue.size());
                int size = invalidationMessageQueue.size();
                for (int i = 0; i < size && (invalidationMessage = invalidationMessageQueue.poll()) != null; ++i) {
                    batchInvalidationMessage.addInvalidationMessage(invalidationMessage);
                }
                EventService eventService = this.nodeEngine.getEventService();
                Collection<EventRegistration> registrations = eventService.getRegistrations("hz:impl:cacheService", cacheName);
                if (!registrations.isEmpty()) {
                    eventService.publishEvent("hz:impl:cacheService", registrations, (Object)batchInvalidationMessage, cacheName.hashCode());
                }
            }
            finally {
                invalidationMessageQueue.release();
            }
        }
    }

    private void invalidateAllCaches() {
        for (Map.Entry entry : this.invalidationMessageMap.entrySet()) {
            String cacheName = (String)entry.getKey();
            this.sendInvalidationEvent(cacheName, null, null);
        }
    }

    static class InvalidationEventQueue
    extends ConcurrentLinkedQueue<CacheSingleInvalidationMessage> {
        private final AtomicInteger elementCount = new AtomicInteger(0);
        private final AtomicBoolean flushingInProgress = new AtomicBoolean(false);

        InvalidationEventQueue() {
        }

        private boolean tryAcquire() {
            return this.flushingInProgress.compareAndSet(false, true);
        }

        private void release() {
            this.flushingInProgress.set(false);
        }

        @Override
        public int size() {
            return this.elementCount.get();
        }

        @Override
        public boolean offer(CacheSingleInvalidationMessage invalidationMessage) {
            boolean offered = super.offer(invalidationMessage);
            if (offered) {
                this.elementCount.incrementAndGet();
            }
            return offered;
        }

        @Override
        public boolean add(CacheSingleInvalidationMessage invalidationMessage) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheSingleInvalidationMessage poll() {
            CacheSingleInvalidationMessage polledItem = (CacheSingleInvalidationMessage)super.poll();
            if (polledItem != null) {
                this.elementCount.decrementAndGet();
            }
            return polledItem;
        }

        @Override
        public CacheSingleInvalidationMessage remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends CacheSingleInvalidationMessage> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class CacheBatchInvalidationMessageSender
    implements Runnable {
        private CacheBatchInvalidationMessageSender() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            for (Map.Entry entry : CacheEventHandler.this.invalidationMessageMap.entrySet()) {
                if (currentThread.isInterrupted()) break;
                InvalidationEventQueue invalidationMessageQueue = (InvalidationEventQueue)entry.getValue();
                if (invalidationMessageQueue.size() <= 0) continue;
                CacheEventHandler.this.flushInvalidationMessages((String)entry.getKey(), invalidationMessageQueue);
            }
        }
    }
}

