/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.lookup;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.TopLevelIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.tree.Tree;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemberImportIndex {
    private final Map<String, Supplier<ClassSymbol>> cache = new LinkedHashMap<String, Supplier<ClassSymbol>>();
    private final ImmutableList<Supplier<ClassSymbol>> classes;

    public MemberImportIndex(final SourceFile source, final CanonicalSymbolResolver resolve, final TopLevelIndex tli, ImmutableList<Tree.ImportDecl> imports) {
        ImmutableList.Builder packageScopes = ImmutableList.builder();
        for (final Tree.ImportDecl i : imports) {
            if (!i.stat()) continue;
            if (i.wild()) {
                packageScopes.add((Object)Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

                    public ClassSymbol get() {
                        LookupResult result = tli.lookup(new LookupKey((Iterable<String>)i.type()));
                        return result != null ? resolve.resolve(source, i.position(), result) : null;
                    }
                }));
                continue;
            }
            this.cache.put((String)Iterables.getLast(i.type()), (Supplier<ClassSymbol>)Suppliers.memoize((Supplier)new Supplier<ClassSymbol>(){

                public ClassSymbol get() {
                    LookupResult result1 = tli.lookup(new LookupKey((Iterable<String>)i.type()));
                    if (result1 == null) {
                        return null;
                    }
                    ClassSymbol sym = (ClassSymbol)result1.sym();
                    for (int i2 = 0; i2 < result1.remaining().size() - 1; ++i2) {
                        sym = resolve.resolveOne(sym, (String)result1.remaining().get(i2));
                    }
                    return sym;
                }
            }));
        }
        this.classes = packageScopes.build();
    }

    public ClassSymbol singleMemberImport(String simpleName) {
        Supplier<ClassSymbol> cachedResult = this.cache.get(simpleName);
        return cachedResult != null ? (ClassSymbol)cachedResult.get() : null;
    }

    public Iterator<ClassSymbol> onDemandImports() {
        return new WildcardSymbols((Iterator<Supplier<ClassSymbol>>)this.classes.iterator());
    }

    private static class WildcardSymbols
    implements Iterator<ClassSymbol> {
        private final Iterator<Supplier<ClassSymbol>> it;

        public WildcardSymbols(Iterator<Supplier<ClassSymbol>> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ClassSymbol next() {
            return (ClassSymbol)this.it.next().get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

