/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.CompileChunk;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import com.sun.tools.sjavac.server.CompilationResult;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.SysInfo;
import java.io.PrintStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CompileJavaPackages
implements Transformer {
    static final int limitOnConcurrency = 3;
    Options args;

    @Override
    public void setExtra(String e) {
    }

    @Override
    public void setExtra(Options a) {
        this.args = a;
    }

    @Override
    public boolean transform(final Sjavac sjavac, Map<String, Set<URI>> pkgSrcs, final Set<URI> visibleSources, Map<URI, Set<String>> visibleClasses, Map<String, Set<String>> oldPackageDependents, URI destRoot, final Map<String, Set<URI>> packageArtifacts, final Map<String, Map<String, Set<String>>> packageDependencies, final Map<String, Map<String, Set<String>>> packageCpDependencies, final Map<String, PubApi> packagePubapis, final Map<String, PubApi> dependencyPubapis, int debugLevel, boolean incremental, int numCores, PrintStream out, PrintStream err) {
        int i;
        Log.debug("Performing CompileJavaPackages transform...");
        boolean rc = true;
        boolean concurrentCompiles = true;
        final String id = Util.extractStringOption("id", sjavac.serverSettings());
        SysInfo sysinfo = sjavac.getSysInfo();
        if (sysinfo == null) {
            Log.error("Could not query server for sysinfo!");
            return false;
        }
        int numMBytes = (int)(sysinfo.maxMemory / 0x100000L);
        Log.debug("Server reports " + numMBytes + "MiB of memory and " + sysinfo.numCores + " cores");
        if (numCores <= 0) {
            numCores = sysinfo.numCores;
            Log.debug("Number of jobs not explicitly set, defaulting to " + sysinfo.numCores);
        } else if (sysinfo.numCores < numCores) {
            Log.debug("Limiting jobs from explicitly set " + numCores + " to cores available on server: " + sysinfo.numCores);
            numCores = sysinfo.numCores;
        } else {
            Log.debug("Number of jobs explicitly set to " + numCores);
        }
        int numCompiles = numCores;
        if (numCores > 3) {
            numCompiles = 3;
        }
        int numSources = 0;
        for (String s : pkgSrcs.keySet()) {
            Set<URI> ss = pkgSrcs.get(s);
            numSources += ss.size();
        }
        int sourcesPerCompile = numSources / numCompiles;
        int kbPerFile = 175;
        String osarch = System.getProperty("os.arch");
        String dataModel = System.getProperty("sun.arch.data.model");
        if ("32".equals(dataModel)) {
            kbPerFile = 119;
        }
        int numRequiredMBytes = kbPerFile * numSources / 1024;
        Log.debug("For os.arch " + osarch + " the empirically determined heap required per file is " + kbPerFile + "KiB");
        Log.debug("Server has " + numMBytes + "MiB of heap.");
        Log.debug("Heuristics say that we need " + numRequiredMBytes + "MiB of heap for all source files.");
        if (numMBytes < numRequiredMBytes) {
            concurrentCompiles = false;
            if (numSources < 500) {
                numCompiles = 1;
                sourcesPerCompile = numSources;
                Log.debug("Compiling as a single source code chunk to stay within heap size limitations!");
            } else if (sourcesPerCompile > 500) {
                numCompiles = numSources / 500;
                sourcesPerCompile = numSources / numCompiles;
                Log.debug("Compiling source as " + numCompiles + " code chunks serially to stay within heap size limitations!");
            }
        } else if (numCompiles > 1) {
            float usagePerCompile = (float)numRequiredMBytes / ((float)numCompiles * 0.7f);
            int usage = (int)(usagePerCompile * (float)numCompiles);
            Log.debug("Heuristics say that for " + numCompiles + " concurrent compiles we need " + usage + "MiB");
            if (usage > numMBytes) {
                numCompiles = 1;
                sourcesPerCompile = numSources;
                Log.debug("Limiting compile to a single thread to stay within heap size limitations!");
            }
        }
        Log.debug("Compiling sources in " + numCompiles + " chunk(s)");
        CompileChunk[] compileChunks = this.createCompileChunks(pkgSrcs, oldPackageDependents, numCompiles, sourcesPerCompile);
        if (Log.isDebugging()) {
            int cn = 1;
            for (CompileChunk cc : compileChunks) {
                Log.debug("Chunk " + cn + " for " + id + " ---------------");
                ++cn;
                for (URI u : cc.srcs) {
                    Log.debug("" + u);
                }
            }
        }
        final CompilationResult[] rn = new CompilationResult[numCompiles];
        Thread[] requests = new Thread[numCompiles];
        long start = System.currentTimeMillis();
        for (i = 0; i < numCompiles; ++i) {
            final int ii = i;
            final CompileChunk cc = compileChunks[i];
            final Object lock = new Object();
            requests[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    rn[ii] = sjavac.compile("n/a", id + "-" + ii, CompileJavaPackages.this.args.prepJavacArgs(), Collections.emptyList(), cc.srcs, visibleSources);
                    Object object = lock;
                    synchronized (object) {
                        for (String pkg : rn[ii].packageArtifacts.keySet()) {
                            Set<URI> pkgArtifacts = rn[ii].packageArtifacts.get(pkg);
                            packageArtifacts.merge(pkg, pkgArtifacts, Util::union);
                        }
                        for (String pkg : rn[ii].packageDependencies.keySet()) {
                            packageDependencies.putIfAbsent(pkg, new HashMap());
                            ((Map)packageDependencies.get(pkg)).putAll(rn[ii].packageDependencies.get(pkg));
                        }
                        for (String pkg : rn[ii].packageCpDependencies.keySet()) {
                            packageCpDependencies.putIfAbsent(pkg, new HashMap());
                            ((Map)packageCpDependencies.get(pkg)).putAll(rn[ii].packageCpDependencies.get(pkg));
                        }
                        for (String pkg : rn[ii].packagePubapis.keySet()) {
                            packagePubapis.merge(pkg, rn[ii].packagePubapis.get(pkg), PubApi::mergeTypes);
                        }
                        for (String pkg : rn[ii].dependencyPubapis.keySet()) {
                            dependencyPubapis.merge(pkg, rn[ii].dependencyPubapis.get(pkg), PubApi::mergeTypes);
                        }
                    }
                }
            };
            if (cc.srcs.size() <= 0) continue;
            String numdeps = "";
            if (cc.numDependents > 0) {
                numdeps = "(with " + cc.numDependents + " dependents) ";
            }
            if (!incremental || cc.numPackages > 16) {
                String info = "(" + cc.pkgFromTos + ")";
                if (info.equals("( to )")) {
                    info = "";
                }
                Log.info("Compiling " + cc.srcs.size() + " files " + numdeps + "in " + cc.numPackages + " packages " + info);
            } else {
                Log.info("Compiling " + cc.pkgNames + numdeps);
            }
            if (concurrentCompiles) {
                requests[ii].start();
                continue;
            }
            requests[ii].run();
            if (rn[i].returnCode == 0) continue;
            Log.info(rn[i].stdout);
            Log.error(rn[i].stderr);
            return false;
        }
        if (concurrentCompiles) {
            for (i = 0; i < numCompiles; ++i) {
                try {
                    requests[i].join();
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < numCompiles; ++i) {
            if (compileChunks[i].srcs.size() <= 0 || rn[i].returnCode == 0) continue;
            Log.info(rn[i].stdout);
            Log.error(rn[i].stderr);
            rc = false;
        }
        long duration = System.currentTimeMillis() - start;
        long minutes = duration / 60000L;
        long seconds = (duration - minutes * 60000L) / 1000L;
        Log.debug("Compilation of " + numSources + " source files took " + minutes + "m " + seconds + "s");
        return rc;
    }

    CompileChunk[] createCompileChunks(Map<String, Set<URI>> pkgSrcs, Map<String, Set<String>> oldPackageDependents, int numCompiles, int sourcesPerCompile) {
        Object[] compileChunks = new CompileChunk[numCompiles];
        for (int i = 0; i < compileChunks.length; ++i) {
            compileChunks[i] = new CompileChunk();
        }
        int ci = 0;
        Object[] packageNames = pkgSrcs.keySet().toArray(new String[0]);
        Arrays.sort(packageNames);
        String from = null;
        for (Object pkgName : packageNames) {
            Object cc = compileChunks[ci];
            Set<URI> s = pkgSrcs.get(pkgName);
            if (((CompileChunk)cc).srcs.size() + s.size() > sourcesPerCompile && ci < numCompiles - 1) {
                from = null;
                cc = compileChunks[++ci];
            }
            ++((CompileChunk)cc).numPackages;
            ((CompileChunk)cc).srcs.addAll(s);
            String justPkgName = Util.justPackageName((String)pkgName);
            Set<String> ss = oldPackageDependents.get(pkgName);
            if (ss != null) {
                ((CompileChunk)cc).numDependents += ss.size();
            }
            if (from == null || from.trim().equals("")) {
                from = justPkgName;
            }
            ((CompileChunk)cc).pkgNames.append(justPkgName + "(" + s.size() + ") ");
            ((CompileChunk)cc).pkgFromTos = from + " to " + justPkgName;
        }
        Arrays.sort(compileChunks);
        return compileChunks;
    }
}

