/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.EnumMap;
import javax.lang.model.type.TypeKind;

@BugPattern(name="ArraysAsListPrimitiveArray", summary="Arrays.asList does not autobox primitive arrays, as one might expect.", explanation="Arrays.asList does not autobox primitive arrays, as one might expect. If you intended to autobox the primitive array, use an asList method from Guava that does autobox.  If you intended to create a singleton list containing the primitive array, use Collections.singletonList to make your intent clearer.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ArraysAsListPrimitiveArray
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> ARRAYS_AS_LIST_SINGLE_ARRAY = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Arrays").named("asList"), Matchers.argumentCount((int)1), Matchers.argument((int)0, (Matcher)Matchers.isArrayType())});
    private static final ImmutableMap<TypeKind, String> GUAVA_UTILS = ArraysAsListPrimitiveArray.getGuavaUtils();

    static ImmutableMap<TypeKind, String> getGuavaUtils() {
        EnumMap<TypeKind, String> guavaUtils = new EnumMap<TypeKind, String>(TypeKind.class);
        guavaUtils.put(TypeKind.BOOLEAN, "Booleans");
        guavaUtils.put(TypeKind.BYTE, "Bytes");
        guavaUtils.put(TypeKind.SHORT, "Shorts");
        guavaUtils.put(TypeKind.INT, "Ints");
        guavaUtils.put(TypeKind.LONG, "Longs");
        guavaUtils.put(TypeKind.CHAR, "Chars");
        guavaUtils.put(TypeKind.FLOAT, "Floats");
        guavaUtils.put(TypeKind.DOUBLE, "Doubles");
        return ImmutableMap.copyOf(guavaUtils);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ARRAYS_AS_LIST_SINGLE_ARRAY.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree array = (ExpressionTree)Iterables.getOnlyElement(tree.getArguments());
        Type componentType = ((Type.ArrayType)ASTHelpers.getType((Tree)array)).getComponentType();
        if (!componentType.isPrimitive()) {
            return Description.NO_MATCH;
        }
        String guavaUtils = (String)GUAVA_UTILS.get((Object)componentType.getKind());
        if (guavaUtils == null) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().addImport("com.google.common.primitives." + guavaUtils).replace((Tree)tree.getMethodSelect(), guavaUtils + ".asList").build();
        return this.describeMatch(tree, (Fix)fix);
    }
}

