/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractTestExceptionChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="TestExceptionChecker", category=BugPattern.Category.JUNIT, summary="Using @Test(expected=...) is discouraged, since the test will pass if *any* statement in the test method throws the expected exception", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class TestExceptionChecker
extends AbstractTestExceptionChecker {
    @Override
    protected Description handleStatements(MethodTree tree, VisitorState state, JCTree.JCExpression expectedException, SuggestedFix baseFix) {
        List<? extends StatementTree> statements = tree.getBody().getStatements();
        if (statements.size() == 1) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        List fixes = (List)Lists.reverse(statements).stream().filter(t -> !JUnitMatchers.containsTestMethod((Tree)t)).map(s -> TestExceptionChecker.buildFix(state, SuggestedFix.builder().merge(baseFix), expectedException, (List<? extends StatementTree>)ImmutableList.of((Object)s))).collect(ImmutableList.toImmutableList());
        if (!fixes.isEmpty()) {
            description.addAllFixes(fixes);
        } else {
            description.addFix((Fix)TestExceptionChecker.buildFix(state, SuggestedFix.builder().merge(baseFix), expectedException, (List<? extends StatementTree>)ImmutableList.of((Object)Iterables.getLast(statements))));
        }
        return description.build();
    }
}

