/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(name="UnsynchronizedOverridesSynchronized", summary="Unsynchronized method overrides a synchronized method.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class UnsynchronizedOverridesSynchronized
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (UnsynchronizedOverridesSynchronized.isSynchronized(methodSymbol)) {
            return Description.NO_MATCH;
        }
        for (Symbol.MethodSymbol s : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes())) {
            if (!UnsynchronizedOverridesSynchronized.isSynchronized(s) || ASTHelpers.isSameType((Type)s.owner.type, (Type)state.getTypeFromString("java.io.InputStream"), (VisitorState)state)) continue;
            return this.buildDescription(methodTree).addFix((Fix)SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.SYNCHRONIZED})).setMessage(String.format("Unsynchronized method %s overrides synchronized method in %s", methodSymbol.getSimpleName(), s.enclClass().getSimpleName())).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean isSynchronized(Symbol.MethodSymbol sym) {
        return sym.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }
}

