/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackSize;
import org.objectweb.asm.MethodVisitor;

public interface StackManipulation {
    public boolean isValid();

    public Size apply(MethodVisitor var1, Implementation.Context var2);

    public static class Compound
    implements StackManipulation {
        private final List<StackManipulation> stackManipulations;

        public Compound(StackManipulation ... stackManipulation) {
            this(Arrays.asList(stackManipulation));
        }

        public Compound(List<StackManipulation> stackManipulations) {
            this.stackManipulations = stackManipulations;
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulations) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            Size size = new Size(0, 0);
            for (StackManipulation stackManipulation : this.stackManipulations) {
                size = size.aggregate(stackManipulation.apply(methodVisitor, implementationContext));
            }
            return size;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.stackManipulations.equals(((Compound)other).stackManipulations);
        }

        public int hashCode() {
            return this.stackManipulations.hashCode();
        }

        public String toString() {
            return "StackManipulation.Compound{stackManipulations=" + this.stackManipulations + "}";
        }
    }

    public static class Size {
        private final int sizeImpact;
        private final int maximalSize;

        public Size(int sizeImpact, int maximalSize) {
            this.sizeImpact = sizeImpact;
            this.maximalSize = maximalSize;
        }

        public int getSizeImpact() {
            return this.sizeImpact;
        }

        public int getMaximalSize() {
            return this.maximalSize;
        }

        public Size aggregate(Size other) {
            return this.aggregate(other.sizeImpact, other.maximalSize);
        }

        private Size aggregate(int sizeChange, int interimMaximalSize) {
            return new Size(this.sizeImpact + sizeChange, Math.max(this.maximalSize, this.sizeImpact + interimMaximalSize));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.maximalSize == ((Size)other).maximalSize && this.sizeImpact == ((Size)other).sizeImpact;
        }

        public int hashCode() {
            return 31 * this.sizeImpact + this.maximalSize;
        }

        public String toString() {
            return "StackManipulation.Size{sizeImpact=" + this.sizeImpact + ", maximalSize=" + this.maximalSize + '}';
        }
    }

    public static enum Trivial implements StackManipulation
    {
        INSTANCE;


        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackSize.ZERO.toIncreasingSize();
        }

        public String toString() {
            return "StackManipulation.Trivial." + this.name();
        }
    }

    public static enum Illegal implements StackManipulation
    {
        INSTANCE;


        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            throw new IllegalStateException("An illegal stack manipulation must not be applied");
        }

        public String toString() {
            return "StackManipulation.Illegal." + this.name();
        }
    }
}

