/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.trace.export;

import io.opencensus.trace.export.RunningSpanStore;
import io.opencensus.trace.export.SampledSpanStore;
import io.opencensus.trace.export.SpanExporter;
import javax.annotation.Nullable;

public abstract class ExportComponent {
    private static final NoopExportComponent NOOP_EXPORT_COMPONENT = new NoopExportComponent();

    public static ExportComponent getNoopExportComponent() {
        return NOOP_EXPORT_COMPONENT;
    }

    public abstract SpanExporter getSpanExporter();

    @Nullable
    public abstract RunningSpanStore getRunningSpanStore();

    @Nullable
    public abstract SampledSpanStore getSampledSpanStore();

    private static final class NoopExportComponent
    extends ExportComponent {
        private NoopExportComponent() {
        }

        @Override
        public SpanExporter getSpanExporter() {
            return SpanExporter.getNoopSpanExporter();
        }

        @Override
        @Nullable
        public RunningSpanStore getRunningSpanStore() {
            return null;
        }

        @Override
        @Nullable
        public SampledSpanStore getSampledSpanStore() {
            return null;
        }
    }
}

