/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.google.common.annotations.Beta;

@Beta
public final class Category
implements Comparable<Category> {
    private final String mName;
    private final int mPriority;
    private final Category mParent;
    public static final Category LINT = Category.create("Lint", 110);
    public static final Category CORRECTNESS = Category.create("Correctness", 100);
    public static final Category SECURITY = Category.create("Security", 90);
    public static final Category PERFORMANCE = Category.create("Performance", 80);
    public static final Category USABILITY = Category.create("Usability", 70);
    public static final Category A11Y = Category.create("Accessibility", 60);
    public static final Category I18N = Category.create("Internationalization", 50);
    public static final Category ICONS = Category.create(USABILITY, "Icons", 73);
    public static final Category TYPOGRAPHY = Category.create(USABILITY, "Typography", 76);
    public static final Category MESSAGES = Category.create(CORRECTNESS, "Messages", 95);
    public static final Category RTL = Category.create(I18N, "Bidirectional Text", 40);

    private Category(Category parent, String name, int priority) {
        this.mParent = parent;
        this.mName = name;
        this.mPriority = priority;
    }

    public static Category create(String name, int priority) {
        return new Category(null, name, priority);
    }

    public static Category create(Category parent, String name, int priority) {
        return new Category(parent, name, priority);
    }

    public Category getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullName() {
        if (this.mParent != null) {
            return this.mParent.getFullName() + ':' + this.mName;
        }
        return this.mName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Category category = (Category)o;
        if (!this.mName.equals(category.mName)) {
            return false;
        }
        return this.mParent != null ? this.mParent.equals(category.mParent) : category.mParent == null;
    }

    public String toString() {
        return this.getFullName();
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    @Override
    public int compareTo(Category other) {
        int delta;
        if (other.mPriority == this.mPriority) {
            if (this.mParent == other) {
                return 1;
            }
            if (other.mParent == this) {
                return -1;
            }
        }
        if ((delta = other.mPriority - this.mPriority) != 0) {
            return delta;
        }
        return this.mName.compareTo(other.mName);
    }
}

