/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import java.io.Serializable;
import javax.lang.model.type.TypeKind;

public abstract class AbstractReturnValueIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final ImmutableSet<String> CLASSES_CONSIDERED_THROWING = ImmutableSet.of((Object)"org.junit.function.ThrowingRunnable", (Object)"org.junit.jupiter.api.function.Executable", (Object)"org.assertj.core.api.ThrowableAssert$ThrowingCallable", (Object)"com.google.truth.ExpectFailure.AssertionCallback", (Object)"com.google.truth.ExpectFailure.DelegatedAssertionCallback", (Object)"com.google.truth.ExpectFailure.StandardSubjectBuilderCallback", (Object[])new String[]{"com.google.truth.ExpectFailure.SimpleSubjectBuilderCallback"});
    private static final Matcher<ExpressionTree> FAIL_METHOD = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.AbstractVerb").named("fail"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("fail"), MethodMatchers.staticMethod().onClass("org.junit.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.Assert").named("fail"), MethodMatchers.staticMethod().onClass("junit.framework.TestCase").named("fail")});
    private static final Matcher<StatementTree> EXPECTED_EXCEPTION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.isLastStatementInBlock(), Matchers.previousStatement((Matcher)Matchers.expressionStatement((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onExactClass("org.junit.rules.ExpectedException")})))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.enclosingNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.TRY)), Matchers.nextStatement((Matcher)Matchers.expressionStatement(FAIL_METHOD))}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.isLastStatementInBlock(), Matchers.parentNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.LAMBDA_EXPRESSION))}), (Matcher & Serializable)(t, s) -> AbstractReturnValueIgnored.methodCallInDeclarationOfThrowingRunnable(s)})});
    private static final Matcher<ExpressionTree> MOCKITO_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("verify"), MethodMatchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when"), MethodMatchers.instanceMethod().onDescendantOf("org.mockito.InOrder").named("verify")});

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{AbstractReturnValueIgnored::isVoidReturningLambdaExpression, Matchers.kindIs((Tree.Kind)Tree.Kind.EXPRESSION_STATEMENT)})), Matchers.not((Matcher)Matchers.methodSelect((Matcher)Matchers.toType(IdentifierTree.class, AbstractReturnValueIgnored.identifierHasName("super")))), Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getType((Tree)t), (VisitorState)s)), this.specializedMatcher(), Matchers.not(AbstractReturnValueIgnored::expectedExceptionTest)}).matches((Tree)methodInvocationTree, state)) {
            return this.describe(methodInvocationTree, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{(Matcher & Serializable)(t, s) -> t.getMode() == MemberReferenceTree.ReferenceMode.INVOKE, AbstractReturnValueIgnored::isVoidReturningMethodReferenceExpression, Matchers.not((Matcher & Serializable)(t, s) -> ASTHelpers.isVoidType((Type)ASTHelpers.getSymbol((MemberReferenceTree)tree).getReturnType(), (VisitorState)s)), Matchers.not((Matcher & Serializable)(t, s) -> AbstractReturnValueIgnored.isThrowingFunctionalInterface(s, ((JCTree.JCMemberReference)t).type)), this.specializedMatcher()}).matches((Tree)tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean isVoidReturningMethodReferenceExpression(MemberReferenceTree tree, VisitorState state) {
        return AbstractReturnValueIgnored.functionalInterfaceReturnsExactlyVoid(((JCTree.JCMemberReference)tree).type, state);
    }

    private static boolean isVoidReturningLambdaExpression(Tree tree, VisitorState state) {
        if (!(tree instanceof LambdaExpressionTree)) {
            return false;
        }
        return AbstractReturnValueIgnored.functionalInterfaceReturnsExactlyVoid(((JCTree.JCLambda)tree).type, state);
    }

    private static boolean functionalInterfaceReturnsExactlyVoid(Type interfaceType, VisitorState state) {
        return state.getTypes().findDescriptorType(interfaceType).getReturnType().getKind() == TypeKind.VOID;
    }

    private static boolean methodCallInDeclarationOfThrowingRunnable(VisitorState state) {
        Tree tree = null;
        block3: for (Tree t : state.getPath()) {
            switch (t.getKind()) {
                case LAMBDA_EXPRESSION: 
                case CLASS: {
                    tree = t;
                    break block3;
                }
                default: {
                    continue block3;
                }
            }
        }
        if (tree == null) {
            return false;
        }
        return AbstractReturnValueIgnored.isThrowingFunctionalInterface(state, ASTHelpers.getType(tree));
    }

    static boolean isThrowingFunctionalInterface(VisitorState state, Type clazzType) {
        return CLASSES_CONSIDERED_THROWING.stream().anyMatch(t -> ASTHelpers.isSubtype((Type)clazzType, (Type)state.getTypeFromString(t), (VisitorState)state));
    }

    public abstract Matcher<? super ExpressionTree> specializedMatcher();

    private static Matcher<IdentifierTree> identifierHasName(String name) {
        return (Matcher & Serializable)(item, state) -> item.getName().contentEquals(name);
    }

    public Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        SuggestedFix fix;
        ExpressionTree identifierExpr = ASTHelpers.getRootAssignable((MethodInvocationTree)methodInvocationTree);
        Type identifierType = null;
        if (identifierExpr != null) {
            if (identifierExpr instanceof JCTree.JCIdent) {
                identifierType = ((JCTree.JCIdent)identifierExpr).sym.type;
            } else if (identifierExpr instanceof JCTree.JCFieldAccess) {
                identifierType = ((JCTree.JCFieldAccess)identifierExpr).sym.type;
            } else {
                throw new IllegalStateException("Expected a JCIdent or a JCFieldAccess");
            }
        }
        Type returnType = ASTHelpers.getReturnType((ExpressionTree)((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect());
        Symbol symbol = ASTHelpers.getSymbol((Tree)identifierExpr);
        if (identifierExpr != null && symbol != null && !symbol.name.contentEquals("this") && returnType != null && state.getTypes().isAssignable(returnType, identifierType)) {
            fix = SuggestedFix.prefixWith((Tree)methodInvocationTree, (String)(state.getSourceForNode((Tree)identifierExpr) + " = "));
        } else {
            Tree parent = state.getPath().getParentPath().getLeaf();
            fix = SuggestedFix.delete((Tree)parent);
        }
        return this.describeMatch(methodInvocationTree, (Fix)fix);
    }

    static boolean expectedExceptionTest(Tree tree, VisitorState state) {
        if (AbstractReturnValueIgnored.mockitoInvocation(tree, state)) {
            return true;
        }
        StatementTree statement = (StatementTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), StatementTree.class);
        return statement != null && EXPECTED_EXCEPTION_MATCHER.matches((Tree)statement, state);
    }

    private static boolean mockitoInvocation(Tree tree, VisitorState state) {
        if (!(tree instanceof JCTree.JCMethodInvocation)) {
            return false;
        }
        JCTree.JCMethodInvocation invocation = (JCTree.JCMethodInvocation)tree;
        if (!(invocation.getMethodSelect() instanceof JCTree.JCFieldAccess)) {
            return false;
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)invocation);
        return MOCKITO_MATCHER.matches((Tree)receiver, state);
    }
}

