/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Map;
import javax.lang.model.element.Modifier;

@BugPattern(name="AutoValueImmutableFields", summary="AutoValue recommends using immutable collections", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, documentSuppression=false)
public class AutoValueImmutableFields
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String MESSAGE = "AutoValue instances should be deeply immutable. Therefore, we recommend returning %s instead. Read more at http://goo.gl/qWo9sC";
    private static final ImmutableListMultimap<String, Matcher<MethodTree>> REPLACEMENT_TO_MATCHERS = ImmutableListMultimap.builder().put((Object)"ImmutableCollection", AutoValueImmutableFields.returning("java.util.Collection")).putAll((Object)"ImmutableList", (Object[])new Matcher[]{Matchers.methodReturns((Matcher)Matchers.isArrayType()), AutoValueImmutableFields.returning("java.util.List"), AutoValueImmutableFields.returning("java.util.ArrayList"), AutoValueImmutableFields.returning("java.util.LinkedList"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableList.Builder")}).putAll((Object)"ImmutableMap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("java.util.Map"), AutoValueImmutableFields.returning("java.util.HashMap"), AutoValueImmutableFields.returning("java.util.LinkedHashMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableMap.Builder")}).putAll((Object)"ImmutableSortedMap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("java.util.SortedMap"), AutoValueImmutableFields.returning("java.util.TreeMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSortedMap.Builder")}).putAll((Object)"ImmutableBiMap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.BiMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableBiMap.Builder")}).putAll((Object)"ImmutableSet", (Object[])new Matcher[]{AutoValueImmutableFields.returning("java.util.Set"), AutoValueImmutableFields.returning("java.util.HashSet"), AutoValueImmutableFields.returning("java.util.LinkedHashSet"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSet.Builder")}).putAll((Object)"ImmutableSortedSet", (Object[])new Matcher[]{AutoValueImmutableFields.returning("java.util.SortedSet"), AutoValueImmutableFields.returning("java.util.TreeSet"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSortedSet.Builder")}).putAll((Object)"ImmutableMultimap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.Multimap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableMultimap.Builder")}).putAll((Object)"ImmutableListMultimap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.ListMultimap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableListMultimap.Builder")}).putAll((Object)"ImmutableSetMultimap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.SetMultimap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSetMultimap.Builder")}).putAll((Object)"ImmutableMultiset", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.Multiset"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableMultiset.Builder")}).putAll((Object)"ImmutableSortedMultiset", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.SortedMultiset"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSortedMultiset.Builder")}).putAll((Object)"ImmutableTable", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.Table"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableTable.Builder")}).putAll((Object)"ImmutableRangeMap", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.RangeMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableRangeMap.Builder")}).putAll((Object)"ImmutableRangeSet", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.RangeSet"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableRangeSet.Builder")}).putAll((Object)"ImmutablePrefixTrie", (Object[])new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.PrefixTrie"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutablePrefixTrie.Builder")}).build();
    private static final Matcher<MethodTree> ABSTRACT_MATCHER = Matchers.hasModifier((Modifier)Modifier.ABSTRACT);

    private static Matcher<MethodTree> returning(String type) {
        return Matchers.methodReturns((Supplier)Suppliers.typeFromString((String)type));
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.hasAnnotation((Tree)tree, (String)"com.google.auto.value.AutoValue", (VisitorState)state)) {
            for (Tree tree2 : tree.getMembers()) {
                MethodTree methodTree;
                if (!(tree2 instanceof MethodTree) || this.isSuppressed(tree2) || !ABSTRACT_MATCHER.matches((Tree)(methodTree = (MethodTree)tree2), state)) continue;
                for (Map.Entry entry : REPLACEMENT_TO_MATCHERS.entries()) {
                    if (!((Matcher)entry.getValue()).matches((Tree)methodTree, state)) continue;
                    state.reportMatch(this.buildDescription(methodTree).setMessage(String.format(MESSAGE, entry.getKey())).build());
                }
            }
        }
        return Description.NO_MATCH;
    }
}

