/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractExpectedExceptionChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import java.util.List;
import javax.annotation.Nullable;

@BugPattern(name="ExpectedExceptionChecker", summary="Calls to ExpectedException#expect should always be followed by exactly one statement.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ExpectedExceptionChecker
extends AbstractExpectedExceptionChecker {
    @Override
    protected Description handleMatch(MethodTree tree, VisitorState state, List<Tree> expectations, List<StatementTree> suffix, @Nullable StatementTree failure) {
        if (suffix.size() <= 1) {
            return Description.NO_MATCH;
        }
        AbstractExpectedExceptionChecker.BaseFix baseFix = this.buildBaseFix(state, expectations, failure);
        ImmutableList fixes = (ImmutableList)Lists.reverse(suffix).stream().filter(t -> !JUnitMatchers.containsTestMethod((Tree)t)).map(t -> baseFix.build((List<? extends StatementTree>)ImmutableList.of((Object)t))).collect(ImmutableList.toImmutableList());
        if (fixes.isEmpty()) {
            fixes = ImmutableList.of((Object)baseFix.build((List<? extends StatementTree>)ImmutableList.of((Object)Iterables.getLast(suffix))));
        }
        return this.buildDescription(tree).addAllFixes((List)fixes).build();
    }
}

